/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.xml;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lang.ReflectionException;
import net.morilib.lang.bean.ClassProposition;
import net.morilib.lang.proposition.Proposition;
import net.morilib.lingua.plural.PluralConverter;
import net.morilib.lingua.plural.SimplePluralConverter;
import net.morilib.parser.xml.IDAttribute;
import net.morilib.parser.xml.XMLBeanFormat;
import net.morilib.parser.xml.XMLBeanParseException;
import net.morilib.util.collection.CollectionTypes;
import net.morilib.util.primitive.ByteArrayVector;
import net.morilib.util.primitive.ByteHashSet;
import net.morilib.util.primitive.ByteList;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.CharacterArrayVector;
import net.morilib.util.primitive.CharacterHashSet;
import net.morilib.util.primitive.CharacterList;
import net.morilib.util.primitive.CharacterSet;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.primitive.DoubleHashSet;
import net.morilib.util.primitive.DoubleList;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.FloatArrayVector;
import net.morilib.util.primitive.FloatHashSet;
import net.morilib.util.primitive.FloatList;
import net.morilib.util.primitive.FloatSet;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.primitive.IntegerHashSet;
import net.morilib.util.primitive.IntegerList;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.LongArrayVector;
import net.morilib.util.primitive.LongHashSet;
import net.morilib.util.primitive.LongList;
import net.morilib.util.primitive.LongSet;
import net.morilib.util.primitive.ShortArrayVector;
import net.morilib.util.primitive.ShortHashSet;
import net.morilib.util.primitive.ShortList;
import net.morilib.util.primitive.ShortSet;

class XMLBeanHelper {
    private static final PluralConverter _E = SimplePluralConverter.ENGLISH;
    private Map<Class<?>, Class<?>> defaults = new LinkedHashMap();

    private XMLBeanHelper() {
        this.defaults.put(ByteList.class, ByteArrayVector.class);
        this.defaults.put(ShortList.class, ShortArrayVector.class);
        this.defaults.put(IntegerList.class, IntegerArrayVector.class);
        this.defaults.put(LongList.class, LongArrayVector.class);
        this.defaults.put(DoubleList.class, DoubleArrayVector.class);
        this.defaults.put(FloatList.class, FloatArrayVector.class);
        this.defaults.put(CharacterList.class, CharacterArrayVector.class);
        this.defaults.put(List.class, ArrayList.class);
        this.defaults.put(ByteSet.class, ByteHashSet.class);
        this.defaults.put(ShortSet.class, ShortHashSet.class);
        this.defaults.put(IntegerSet.class, IntegerHashSet.class);
        this.defaults.put(LongSet.class, LongHashSet.class);
        this.defaults.put(DoubleSet.class, DoubleHashSet.class);
        this.defaults.put(FloatSet.class, FloatHashSet.class);
        this.defaults.put(CharacterSet.class, CharacterHashSet.class);
        this.defaults.put(Set.class, HashSet.class);
        this.defaults.put(Map.class, HashMap.class);
    }

    public static XMLBeanHelper getInstance() {
        return new XMLBeanHelper();
    }

    public Object newInstance(Class<?> cls) {
        try {
            Field[] fs;
            Constructor<?> c = cls.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Object res = c.newInstance(new Object[0]);
            Field[] fieldArray = fs = cls.getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Class<?> c2 = f.getType();
                f.setAccessible(true);
                for (Class<?> c0 : this.defaults.keySet()) {
                    if (!c0.isAssignableFrom(c2)) continue;
                    Object l = c2.isInterface() ? this.defaults.get(c0).newInstance() : c2.newInstance();
                    f.set(res, l);
                    break;
                }
                ++n2;
            }
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    private static Object checkPrimitive(Class<?> c, String msg) {
        if (c.isPrimitive()) {
            throw new XMLBeanParseException(msg);
        }
        return null;
    }

    private static Number parseNum(String fs, String v, boolean isBig) {
        DecimalFormat nf = new DecimalFormat(fs);
        nf.setParseBigDecimal(isBig);
        try {
            return Float.valueOf(nf.parse(v).floatValue());
        }
        catch (ParseException e) {
            throw new XMLBeanParseException(e.getMessage());
        }
    }

    private static String trim2(Object w) {
        if (w == null) {
            return null;
        }
        String r = w.toString();
        if (r != null) {
            r = r.replaceAll("\\A(\\p{javaWhitespace})+", "");
            return (r = r.replaceAll("(\\p{javaWhitespace})+\\G", "")).equals("") ? null : r;
        }
        return null;
    }

    private static String trim3(Object w) {
        if (w == null) {
            return null;
        }
        String r = w.toString();
        if (r != null) {
            r = r.replaceAll("\\A(\\p{javaWhitespace})+", "");
            r = r.replaceAll("(\\p{javaWhitespace})+\\G", "");
            return r;
        }
        return null;
    }

    public static Object cast(Class<?> c, Object w, AnnotatedElement ae) {
        XMLBeanFormat a = ae.getAnnotation(XMLBeanFormat.class);
        String fs = null;
        if (a != null) {
            fs = a.value();
        }
        if (String.class.isAssignableFrom(c)) {
            if (w == null) {
                return null;
            }
            if (!(w instanceof String)) {
                throw new ClassCastException();
            }
            String v = XMLBeanHelper.trim3(w);
            v = v.replaceAll("\n(\\p{javaWhitespace})+", "\n");
            return v;
        }
        if (Integer.TYPE.isAssignableFrom(c) || Integer.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Integer required");
            }
            return Integer.parseInt(v.toString());
        }
        if (Long.TYPE.isAssignableFrom(c) || Long.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Long required");
            }
            return Long.parseLong(v);
        }
        if (Boolean.TYPE.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Boolean required");
            }
            if (!v.equalsIgnoreCase("true") && !v.equalsIgnoreCase("on")) {
                return false;
            }
            return true;
        }
        if (Float.TYPE.isAssignableFrom(c) || Float.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Float required");
            }
            if (fs != null && !fs.equals("")) {
                return Float.valueOf(XMLBeanHelper.parseNum(fs, v, false).floatValue());
            }
            return Float.valueOf(Float.parseFloat(v));
        }
        if (Double.TYPE.isAssignableFrom(c) || Double.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Double required");
            }
            if (fs != null && !fs.equals("")) {
                return XMLBeanHelper.parseNum(fs, v, false).doubleValue();
            }
            return Double.parseDouble(v);
        }
        if (Short.TYPE.isAssignableFrom(c) || Short.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Short required");
            }
            return Short.parseShort(v);
        }
        if (Byte.TYPE.isAssignableFrom(c) || Byte.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Byte required");
            }
            return Byte.parseByte(v);
        }
        if (Character.TYPE.isAssignableFrom(c) || Character.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return XMLBeanHelper.checkPrimitive(c, "Character required");
            }
            if (v.length() == 1) {
                return Character.valueOf(v.charAt(0));
            }
            return Character.valueOf(v.charAt(0));
        }
        if (BigDecimal.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return null;
            }
            if (fs != null && !fs.equals("")) {
                Number n = XMLBeanHelper.parseNum(fs, v, true);
                return n instanceof BigDecimal ? n : null;
            }
            return new BigDecimal(v);
        }
        if (Date.class.isAssignableFrom(c)) {
            String v = XMLBeanHelper.trim2(w);
            if (v == null) {
                return null;
            }
            if (fs != null && !fs.equals("")) {
                try {
                    SimpleDateFormat sf = new SimpleDateFormat(fs);
                    return sf.parse(v);
                }
                catch (ParseException e) {
                    throw new XMLBeanParseException(e.getMessage());
                }
            }
            throw new XMLBeanParseException("Date format required");
        }
        if (!c.isAssignableFrom(w.getClass())) {
            throw new ClassCastException();
        }
        return w;
    }

    public void setField(Object o, String q, Object val) {
        try {
            Field[] fs;
            Field[] fieldArray = fs = o.getClass().getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Class<?> c2 = f.getType();
                if (Collection.class.isAssignableFrom(c2) && _E.isPlural(q, f.getName())) {
                    f.setAccessible(true);
                    Object l = f.get(o);
                    Method m = l.getClass().getMethod("add", Object.class);
                    m.invoke(l, val);
                    return;
                }
                if (Map.class.isAssignableFrom(c2) && _E.isPlural(q, f.getName())) {
                    f.setAccessible(true);
                    Object p = f.get(o);
                    Method m = p.getClass().getMethod("put", Object.class, Object.class);
                    IDAttribute a = f.getAnnotation(IDAttribute.class);
                    Field g = val.getClass().getDeclaredField(a == null ? "id" : a.value());
                    if (!String.class.isAssignableFrom(g.getType())) {
                        throw new XMLBeanParseException();
                    }
                    g.setAccessible(true);
                    m.invoke(p, g.get(val), val);
                    return;
                }
                if (q.equals(f.getName())) {
                    f.setAccessible(true);
                    f.set(o, val);
                    return;
                }
                ++n2;
            }
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStringField(Object o, String q) {
        try {
            Field[] fs;
            Field[] fieldArray = fs = o.getClass().getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Field f = fieldArray[n2];
                if (q.equals(f.getName()) && String.class.isAssignableFrom(f.getType())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
    }

    private boolean isBoundString(Class<?> cl) {
        Proposition<ClassProposition> cp = ClassProposition.superClass(CollectionTypes.getType(cl));
        return Collection.class.isAssignableFrom(cl) && cp.is1(String.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStringListField(Object o, String q) {
        try {
            Field[] fs;
            Field[] fieldArray = fs = o.getClass().getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Field f = fieldArray[n2];
                Class<?> cl = f.getType();
                if (_E.isPlural(q, f.getName()) && this.isBoundString(cl)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStringListFieldExtra(Object o, String q) {
        try {
            Field[] fs;
            Field[] fieldArray = fs = o.getClass().getDeclaredFields();
            int n = fs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Field f = fieldArray[n2];
                Class<?> cl = f.getType();
                if (q.equals(f.getName()) && this.isBoundString(cl)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
    }
}

