/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.special;

import net.morilib.math.analysis.inexact.DoubleContinuedFractionFunction;
import net.morilib.math.special.Gamma2;

public class BetaFunction {
    public static double logBeta(double a, double b) {
        return Gamma2.lnGamma(a) + Gamma2.lnGamma(b) - Gamma2.lnGamma(a + b);
    }

    public static double I(double x, double a, double b) {
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b)) {
            return Double.NaN;
        }
        if (x <= 0.0 || x > 1.0 || a <= 0.0 || b <= 0.0) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return 1.0;
        }
        double k = a * Math.log(x) + b * Math.log(1.0 - x);
        k = k - Math.log(a) - BetaFunction.logBeta(a, b);
        return Math.exp(k) * new IBeta(a, b).f(x);
    }

    static class IBeta
    extends DoubleContinuedFractionFunction {
        private double a;
        private double b;

        private IBeta(double a, double b) {
            this.a = a;
            this.b = b;
        }

        @Override
        protected double getA1(double x) {
            return 1.0;
        }

        @Override
        protected double getAn(int n, double x) {
            double r;
            int k = (n - 1) / 2;
            if (n % 2 > 0) {
                r = (double)k / (this.a + (double)(2 * k) - 1.0) * (this.b - (double)k) / (this.a + (double)(2 * k)) * x;
            } else {
                r = -(this.a + (double)k) / (this.a + (double)(2 * k));
                r = r * (this.a + this.b + (double)k) / (this.a + (double)(2 * k) + 1.0) * x;
            }
            return r;
        }

        @Override
        protected double getB0(double x) {
            return 0.0;
        }

        @Override
        protected double getB1(double x) {
            return 1.0;
        }

        @Override
        protected double getBn(int n, double x) {
            return 1.0;
        }
    }
}

