/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.series;

import java.util.Iterator;
import net.morilib.lang.number.Rational;

public abstract class ContinuedFractionSeries
implements Iterator<Rational> {
    protected Rational d = Rational.ZERO;
    protected Rational dh = Rational.ONE;
    protected Rational h = Rational.ONE;
    protected int n;

    protected abstract Rational getB0();

    protected abstract Rational getA1();

    protected abstract Rational getB1();

    protected abstract Rational getAn(int var1);

    protected abstract Rational getBn(int var1);

    protected Rational init() {
        Rational b0 = this.getB0();
        Rational a1 = this.getA1();
        Rational b1 = this.getB1();
        this.d = Rational.ONE.divide(b1);
        this.dh = a1.divide(b1);
        this.h = b0.add(this.dh);
        this.n = 1;
        return this.h;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Rational next() {
        Rational a = this.getAn(this.n);
        Rational b = this.getBn(this.n);
        this.d = Rational.ONE.divide(b.add(a.multiply(this.d)));
        this.dh = b.multiply(this.d).subtract(Rational.ONE).multiply(this.dh);
        this.h = this.h.add(this.dh);
        ++this.n;
        return this.h;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

