/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.zip;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.zip.LispZipEntry;
import net.morilib.lisp.zip.LispZipFile;
import net.morilib.util.IOs;
import net.morilib.util.Iterators;

public class ExtractZipEntry
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c3a = Iterators.nextIf(itr, LispBoolean.FALSE);
        FileOutputStream ous = null;
        InputStream ins = null;
        SubrUtils.checkTerminated(itr, body, mesg);
        if (c1a instanceof LispZipFile) {
            Undef undef;
            ZipFile zf = ((LispZipFile)c1a).zipfile;
            if (c2a instanceof LispZipEntry) {
                ZipEntry ze = ((LispZipEntry)c1a).entry;
                return SubrUtils.nvl(ze.getComment());
            }
            ZipEntry ze = zf.getEntry(SubrUtils.getString(c2a, mesg));
            if (ze == null || ze.isDirectory()) {
                throw mesg.getError("err.zip.entry.notfound", c2a);
            }
            try {
                if (c3a.isTrue()) {
                    ous = new FileOutputStream(SubrUtils.getString(c3a, mesg));
                } else {
                    String ss = ze.getName();
                    if (ss.lastIndexOf(47) >= 0) {
                        ss = ss.substring(ss.lastIndexOf(47) + 1);
                    }
                    ous = new FileOutputStream(LispFiles.getFile(env, ss));
                }
                ins = zf.getInputStream(ze);
                IOs.copy(ins, ous);
                undef = Undef.UNDEF;
            }
            catch (IOException e) {
                try {
                    throw mesg.getError("err.io");
                }
                catch (Throwable throwable) {
                    IOs.close(ins);
                    IOs.close(ous);
                    throw throwable;
                }
            }
            IOs.close(ins);
            IOs.close(ous);
            return undef;
        }
        throw mesg.getError("err.zip.require.zipfile", c1a);
    }
}

