/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public interface HomogeneousArray
extends ILispVector {
    public boolean equalsArray(Datum var1, Datum var2);

    public void set(int var1, LispReal var2);

    public void set(int var1, int var2);

    public void set(int var1, long var2);

    public void set(int var1, double var2);

    public void checkRange(LispReal var1, LispMessage var2);

    public static class VectorLength
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof HomogeneousArray) {
                return LispInteger.valueOf(((HomogeneousArray)((Object)c1a)).size());
            }
            throw mesg.getError("err.uvector.require", c1a);
        }
    }

    public static class VectorRef
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof HomogeneousArray) {
                HomogeneousArray v = (HomogeneousArray)((Object)c1a);
                int i = SubrUtils.getSmallInt(c2a, mesg);
                if (i < 0) {
                    throw mesg.getError("err.require.int.nonnegative", c2a);
                }
                if (i >= v.size()) {
                    throw mesg.getError("err.vector.outofrange");
                }
                return v.get(i);
            }
            throw mesg.getError("err.uvector.require", c1a);
        }
    }

    public static class VectorSetS
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (c1a instanceof HomogeneousArray) {
                HomogeneousArray h = (HomogeneousArray)((Object)c1a);
                int i = SubrUtils.getSmallInt(c2a, mesg);
                if (i < 0) {
                    throw mesg.getError("err.require.int.nonnegative", c2a);
                }
                if (i >= h.size()) {
                    throw mesg.getError("err.vector.outofrange");
                }
                h.checkRange((LispReal)c3a, mesg);
                h.set(i, (LispReal)c3a);
                return Undef.UNDEF;
            }
            throw mesg.getError("err.uvector.require", c1a);
        }
    }
}

