/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.List;
import javax.swing.Icon;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.painter.SchlushBufferedFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.swing.ILispIcon;

public class LispFrameIcon
extends SchlushBufferedFrame
implements ILispIcon {
    private int width;
    private int height;
    private final Icon icon = new Icon(){

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            LispFrameIcon.this.paintDrawers(g, c);
        }

        @Override
        public int getIconWidth() {
            return LispFrameIcon.this.width;
        }

        @Override
        public int getIconHeight() {
            return LispFrameIcon.this.height;
        }
    };

    private LispFrameIcon(int w, int h, CoordinateMap c) {
        super(c);
        this.width = w;
        this.height = h;
    }

    @Override
    public int getImageWidth(Image img) {
        return img.getHeight(null);
    }

    @Override
    public int getImageHeight(Image img) {
        return img.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void loadImage(Image img) throws InterruptedException {
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<frame-icon>");
    }

    /* synthetic */ LispFrameIcon(int n, int n2, CoordinateMap coordinateMap, LispFrameIcon lispFrameIcon) {
        this(n, n2, coordinateMap);
    }

    public static class MakeFrameIcon
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() != 2 && l.size() != 6) {
                throw mesg.getError("err.argument", body);
            }
            if (l.size() == 2) {
                LispUtils.checkReal(l, 0, mesg);
                LispUtils.checkReal(l, 1, mesg);
            } else {
                LispUtils.checkReal(l, 0, mesg);
                LispUtils.checkReal(l, 1, mesg);
                LispUtils.checkReal(l, 2, mesg);
                LispUtils.checkReal(l, 3, mesg);
                LispUtils.checkReal(l, 4, mesg);
                LispUtils.checkReal(l, 5, mesg);
            }
            int x = l.get(0).getInt();
            int y = l.get(1).getInt();
            if (l.size() == 2) {
                return new LispFrameIcon(x, y, null, null);
            }
            double x1 = l.get(2).getRealDouble();
            double y1 = l.get(3).getRealDouble();
            double x2 = l.get(4).getRealDouble();
            double y2 = l.get(5).getRealDouble();
            return new LispFrameIcon(x, y, new CoordinateMap(x1, y1, x2, y2), null);
        }
    }
}

