/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sort;

import java.util.Comparator;
import java.util.Iterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.sort.SRFI95Sequence;
import net.morilib.util.Iterators;

public final class SRFI95Utils {
    public static Comparator<Datum> getCmp(final Procedure cmp, final Procedure key, final Environment env, final LispMessage mesg) {
        if (key == null) {
            return new Comparator<Datum>(){

                @Override
                public int compare(Datum o1, Datum o2) {
                    if (Scheme.callva(cmp, env, mesg, o1, o2).isTrue()) {
                        return -1;
                    }
                    if (Scheme.callva(cmp, env, mesg, o2, o1).isTrue()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        return new Comparator<Datum>(){

            @Override
            public int compare(Datum d1, Datum d2) {
                Datum o1 = Scheme.callva(key, env, mesg, d1);
                Datum o2 = Scheme.callva(key, env, mesg, d2);
                if (Scheme.callva(cmp, env, mesg, o1, o2).isTrue()) {
                    return -1;
                }
                if (Scheme.callva(cmp, env, mesg, o2, o1).isTrue()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static SRFI95Sequence<?> next(Iterator<Datum> itr, Datum body, LispMessage mesg) {
        Datum d = Iterators.nextIf(itr, null);
        if (d instanceof SRFI95Sequence) {
            return (SRFI95Sequence)((Object)d);
        }
        throw mesg.getError("err.srfi95.require.sequence", d);
    }
}

