/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.serialize;

import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.r6rs.io.ILispBinaryOutputPort;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Objects;

public class SerializeDatum
extends Subr {
    static void serialize(ObjectOutput oos, Object d, LispMessage mesg) throws IOException {
        if (d instanceof Serializable) {
            oos.writeObject(d);
        } else {
            if (!(d instanceof JavaObjective)) {
                throw mesg.getError("err.serialize.require.serializable", Objects.toString(d));
            }
            if ((d = ((JavaObjective)d).toObject()) instanceof Serializable) {
                oos.writeObject(d);
            } else {
                throw mesg.getError("err.serialize.require.serializable", Objects.toString(d));
            }
        }
    }

    static void serialize(XMLEncoder oos, Object d, LispMessage mesg) throws IOException {
        if (d instanceof Serializable) {
            oos.writeObject(d);
        } else {
            if (!(d instanceof JavaObjective)) {
                throw mesg.getError("err.serialize.require.serializable", Objects.toString(d));
            }
            if ((d = ((JavaObjective)d).toObject()) instanceof Serializable) {
                oos.writeObject(d);
            } else {
                throw mesg.getError("err.serialize.require.serializable", Objects.toString(d));
            }
        }
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (c1a instanceof ILispBinaryOutputPort) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(((ILispBinaryOutputPort)((Object)c1a)).getOutputStream());
                SerializeDatum.serialize(oos, (Object)c2a, mesg);
                return Undef.UNDEF;
            }
            catch (IOException e) {
                throw mesg.getError("err.io");
            }
        }
        throw mesg.getError("err.io.require.port.binary.output", c1a);
    }
}

