/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import net.morilib.lisp.r6rs.io.transcd.LispEolStyle;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;
import net.morilib.util.io.UTF16;

public class NewlineOutputTranscoder
implements OutputTranscoder {
    private OutputTranscoder tr;
    private LispEolStyle eol;

    public NewlineOutputTranscoder(OutputTranscoder tr, LispEolStyle eol) {
        this.tr = tr;
        this.eol = eol;
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }

    @Override
    public void write(int c) throws IOException {
        if (c == 10) {
            this.tr.write(this.eol.newline);
        } else {
            this.tr.write(c);
        }
    }

    @Override
    public void write(String b) throws IOException {
        this.write(UTF16.getInts(b));
    }

    @Override
    public void write(String b, int off, int len) throws IOException {
        this.write(UTF16.getInts(b), off, len);
    }

    @Override
    public void write(int[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int[] b, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.write(b[i]);
            ++i;
        }
    }

    @Override
    public void flush() throws IOException {
        this.tr.flush();
    }
}

