/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.util.Arrays;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.NewlineInputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.NewlineOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;
import net.morilib.util.io.UTF16;

public class LispEolStyle
extends Datum2 {
    public static final LispEolStyle CR = new LispEolStyle(new int[]{13});
    public static final LispEolStyle LF = new LispEolStyle(new int[]{10});
    public static final LispEolStyle CRLF = new LispEolStyle(new int[]{13, 10});
    public static final LispEolStyle NEL = new LispEolStyle(new int[]{133});
    public static final LispEolStyle CRNEL = new LispEolStyle(new int[]{13, 133});
    public static final LispEolStyle LS = new LispEolStyle(new int[]{8232});
    public static final LispEolStyle NONE = new LispEolStyle(null){

        @Override
        public InputTranscoder getInputTranscoder(InputTranscoder tr) {
            return tr;
        }

        @Override
        public OutputTranscoder getOutputTranscoder(OutputTranscoder tr) {
            return tr;
        }
    };
    int[] newline;

    LispEolStyle(int[] newline) {
        this.newline = newline;
    }

    public static LispEolStyle getInstance(int[] newline) {
        int[] l = new int[newline.length];
        System.arraycopy(newline, 0, l, 0, l.length);
        return new LispEolStyle(l);
    }

    public static LispEolStyle getNative() {
        String s = System.getProperty("line.separator");
        if (s == null || s.length() == 0) {
            throw new RuntimeException();
        }
        return new LispEolStyle(UTF16.getInts(s));
    }

    public InputTranscoder getInputTranscoder(InputTranscoder tr) {
        return new NewlineInputTranscoder(tr, this, 10);
    }

    public OutputTranscoder getOutputTranscoder(OutputTranscoder tr) {
        return new NewlineOutputTranscoder(tr, this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.newline);
    }

    public boolean equals(Object o) {
        if (o instanceof LispEolStyle) {
            return Arrays.equals(this.newline, ((LispEolStyle)o).newline);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<eol-style ");
        if (this.newline == null) {
            buf.append("none");
        } else if (Arrays.equals(this.newline, LispEolStyle.CR.newline)) {
            buf.append("cr");
        } else if (Arrays.equals(this.newline, LispEolStyle.LF.newline)) {
            buf.append("lf");
        } else if (Arrays.equals(this.newline, LispEolStyle.CRLF.newline)) {
            buf.append("crlf");
        } else if (Arrays.equals(this.newline, LispEolStyle.NEL.newline)) {
            buf.append("nel");
        } else if (Arrays.equals(this.newline, LispEolStyle.CRNEL.newline)) {
            buf.append("crnel");
        } else if (Arrays.equals(this.newline, LispEolStyle.LS.newline)) {
            buf.append("ls");
        } else {
            buf.append("unknown");
        }
        buf.append(">");
    }
}

