/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.process;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.process.ProcessSubrUtils;
import net.morilib.lisp.process.ProcessSyntaxException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class RunProcess
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = Iterators.nextIf(itr);
        Map<Symbol, Datum> envp = null;
        String dir = null;
        if (c2a instanceof LispString) {
            dir = c2a.getString();
        } else if (c2a != null) {
            envp = LispUtils.assocToMapSymbol(c2a);
            dir = SubrUtils.nextString((Iterator<Datum>)itr, null, mesg);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            return LispInteger.valueOf(ProcessSubrUtils.runProcess(new ConsIterator(c1a), envp, dir, null));
        }
        catch (ProcessSyntaxException e) {
            throw mesg.getError("err.process.processsyntax", c1a);
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

