/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.snmp;

import net.morilib.lang.algebra.Addable;
import net.morilib.lang.algebra.Subtractable;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispArithmeticException;

public class LispTimeTicks
extends Datum2
implements Addable<LispTimeTicks>,
Subtractable<LispTimeTicks> {
    private long ticks;

    public LispTimeTicks(long x) {
        this.ticks = x;
        if (this.ticks < 0L) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public LispTimeTicks subtract(LispTimeTicks x) {
        return new LispTimeTicks(this.ticks + x.ticks);
    }

    @Override
    public LispTimeTicks add(LispTimeTicks x) {
        long t = this.ticks - x.ticks;
        if (t < 0L) {
            throw new LispArithmeticException("not negative");
        }
        return new LispTimeTicks(t);
    }

    @Override
    public LispTimeTicks multiply(int n) {
        return new LispTimeTicks(this.ticks * (long)n);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(String.format("#<time-ticks %d.%03dsec>", this.ticks / 1000L, this.ticks % 1000L));
    }

    public int hashCode() {
        return (int)this.ticks;
    }

    public boolean equals(Object o) {
        if (o instanceof LispTimeTicks) {
            return this.ticks == ((LispTimeTicks)o).ticks;
        }
        return false;
    }
}

