/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.constants;

import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispAlternatingSeriesNumber;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInexactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.math.constants.AlternatingSeriesNumber;
import net.morilib.math.constants.ChampernowneConstant;

public final class LispChampernowneConstant
extends LispAlternatingSeriesNumber {
    public static final LispChampernowneConstant CONSTANT = new LispChampernowneConstant(ChampernowneConstant.INSTANCE);

    private LispChampernowneConstant(AlternatingSeriesNumber e) {
        super(e);
    }

    private LispChampernowneConstant(Rational scale, Rational shift) {
        super(new ChampernowneConstant(scale, shift));
    }

    public static LispExactReal scaled(Rational scale, Rational shift) {
        return scale.isZero() ? LispInteger.ZERO : new LispChampernowneConstant(scale, shift);
    }

    public static LispExactReal scaled(LispInexactReal scale, LispInexactReal shift) {
        return scale.isZero() ? LispInteger.ZERO : new LispChampernowneConstant(scale.getRational(), shift.getRational());
    }

    @Override
    public LispChampernowneConstant uminus() {
        return new LispChampernowneConstant(this.value.getScale().negate(), this.value.getShift().negate());
    }

    @Override
    public LispExactReal prototype(Rational scale, Rational shift) {
        return scale.isZero() ? LispInteger.ZERO : new LispChampernowneConstant(scale, shift);
    }
}

