/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import net.morilib.ldap.AndAttributeFilter;
import net.morilib.ldap.AttributeFilter;
import net.morilib.ldap.FilterRelation;
import net.morilib.ldap.LDAPManager;
import net.morilib.ldap.NotAttributeFilter;
import net.morilib.ldap.OrAttributeFilter;
import net.morilib.ldap.SimpleAttributeFilter;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;

public class LispLDAPService
extends Datum2 {
    private static final Symbol AND = Symbol.getSymbol("and");
    private static final Symbol OR = Symbol.getSymbol("or");
    private static final Symbol NOT = Symbol.getSymbol("not");
    private static final Symbol EQ = Symbol.getSymbol("=");
    private static final Symbol AEQ = Symbol.getSymbol("~=");
    private static final Symbol LE = Symbol.getSymbol("<=");
    private static final Symbol GE = Symbol.getSymbol(">=");
    private static final Symbol OBJECT = Symbol.getSymbol("object");
    private static final Symbol ONELEVEL = Symbol.getSymbol("1level");
    private static final Symbol SUBTREE = Symbol.getSymbol("subtree");
    private static final Symbol ADD = Symbol.getSymbol("add");
    private static final Symbol REPLACE = Symbol.getSymbol("replace");
    private static final Symbol REMOVE = Symbol.getSymbol("remove");
    LDAPManager manager;

    public LispLDAPService(LDAPManager manager) {
        this.manager = manager;
    }

    public static AttributeFilter parseFilter(Datum d, LispMessage mesg) {
        try {
            List<Datum> l = LispUtils.consToList(d, mesg);
            if (l.get(0).equals(AND)) {
                AttributeFilter[] af = new AttributeFilter[l.size() - 1];
                int i = 0;
                while (i < af.length) {
                    af[i] = LispLDAPService.parseFilter(l.get(i + 1), mesg);
                    ++i;
                }
                return new AndAttributeFilter(af);
            }
            if (l.get(0).equals(OR)) {
                AttributeFilter[] af = new AttributeFilter[l.size() - 1];
                int i = 0;
                while (i < af.length) {
                    af[i] = LispLDAPService.parseFilter(l.get(i + 1), mesg);
                    ++i;
                }
                return new OrAttributeFilter(af);
            }
            if (l.get(0).equals(NOT) && l.size() == 2) {
                return new NotAttributeFilter(LispLDAPService.parseFilter(l.get(1), mesg));
            }
            if (l.get(0).equals(EQ) && l.size() == 3) {
                return new SimpleAttributeFilter(SubrUtils.getString(l.get(1), mesg), SubrUtils.getString(l.get(2), mesg), FilterRelation.EQUAL);
            }
            if (l.get(0).equals(AEQ) && l.size() == 3) {
                return new SimpleAttributeFilter(SubrUtils.getString(l.get(1), mesg), SubrUtils.getString(l.get(2), mesg), FilterRelation.APPROX);
            }
            if (l.get(0).equals(LE) && l.size() == 3) {
                return new SimpleAttributeFilter(SubrUtils.getString(l.get(1), mesg), SubrUtils.getString(l.get(2), mesg), FilterRelation.LESS);
            }
            if (l.get(0).equals(GE) && l.size() == 3) {
                return new SimpleAttributeFilter(SubrUtils.getString(l.get(1), mesg), SubrUtils.getString(l.get(2), mesg), FilterRelation.GREATER);
            }
            throw mesg.getError("err.ldap.filter.invalid", d);
        }
        catch (LispException e) {
            throw mesg.getError("err.ldap.filter.invalid", d);
        }
    }

    public static int parseScope(Datum d, LispMessage mesg) {
        if (d.equals(OBJECT)) {
            return 0;
        }
        if (d.equals(ONELEVEL)) {
            return 1;
        }
        if (d.equals(SUBTREE)) {
            return 2;
        }
        throw mesg.getError("err.ldap.scope.invalid", d);
    }

    public static Attributes parseAttributes(Datum d, LispMessage mesg) {
        BasicAttributes as = new BasicAttributes();
        try {
            ConsIterator itr = new ConsIterator(d);
            while (itr.hasNext()) {
                ConsIterator jtr = new ConsIterator(itr.next());
                String s1 = SubrUtils.nextString((Iterator<Datum>)jtr, mesg, d);
                BasicAttribute at = new BasicAttribute(s1);
                while (jtr.hasNext()) {
                    at.add(SubrUtils.nextString((Iterator<Datum>)jtr, mesg, d));
                }
                SubrUtils.checkProper(jtr, d, mesg);
                as.put(at);
            }
            SubrUtils.checkProper(itr, d, mesg);
        }
        catch (LispException e) {
            throw mesg.getError("err.ldap.attrs.invalid", d);
        }
        return as;
    }

    public static ModificationItem[] parseModification(Datum d, LispMessage mesg) {
        ArrayList<ModificationItem> ms = new ArrayList<ModificationItem>();
        try {
            ConsIterator itr = new ConsIterator(d);
            while (itr.hasNext()) {
                int mf;
                ConsIterator jtr = new ConsIterator(itr.next());
                Datum k1 = SubrUtils.nextIf((Iterator<Datum>)jtr, mesg, d);
                if (k1.equals(ADD)) {
                    mf = 1;
                } else if (k1.equals(REPLACE)) {
                    mf = 2;
                } else if (k1.equals(REMOVE)) {
                    mf = 3;
                } else {
                    throw mesg.getError("err.ldap.attrs.invalid", d);
                }
                String s1 = SubrUtils.nextString((Iterator<Datum>)jtr, mesg, d);
                BasicAttribute at = new BasicAttribute(s1);
                while (jtr.hasNext()) {
                    at.add(SubrUtils.nextString((Iterator<Datum>)jtr, mesg, d));
                }
                SubrUtils.checkProper(jtr, d, mesg);
                ModificationItem mi = new ModificationItem(mf, at);
                ms.add(mi);
            }
            SubrUtils.checkProper(itr, d, mesg);
        }
        catch (LispException e) {
            throw mesg.getError("err.ldap.attrs.invalid", d);
        }
        return ms.toArray(new ModificationItem[0]);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<ldap-service>");
    }
}

