/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispFlexibleSequence;
import net.morilib.lisp.collection.LispSequence;
import net.morilib.lisp.subr.IsEqual;

public class LispArrayList
extends Datum2
implements LispFlexibleSequence {
    private static final Procedure EQUAL = new IsEqual();
    private static final Symbol ARRAY_LIST = Symbol.getSymbol("array-list");
    private List<Datum> list;

    public LispArrayList() {
        this(new ArrayList<Datum>());
    }

    public LispArrayList(List<Datum> list) {
        this.list = new ArrayList<Datum>(list);
    }

    @Override
    public Datum get(int index) {
        return this.list.get(index);
    }

    @Override
    public Datum first() {
        return this.list.get(0);
    }

    @Override
    public Datum last() {
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public LispArrayList copySet(int index, Datum d) {
        return new LispArrayList(this.list).set(index, d);
    }

    @Override
    public LispArrayList set(int index, Datum d) {
        this.list.set(index, d);
        return this;
    }

    @Override
    public LispArrayList replace(LispSequence src, int srcPos, int destPos, int len) {
        return new LispArrayList(this.list).arraycopy(src, srcPos, destPos, len);
    }

    @Override
    public LispArrayList arraycopy(LispSequence src, int srcPos, int destPos, int len) {
        int i = 0;
        while (i < len) {
            this.list.set(destPos + i, src.get(srcPos + i));
            ++i;
        }
        return this;
    }

    @Override
    public Datum copy(int b, int e) {
        return new LispArrayList(this.list.subList(b, e));
    }

    @Override
    public Procedure equivalence() {
        return EQUAL;
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public LispArrayList copyAdd(Datum d) {
        return new LispArrayList(this.list).add(d);
    }

    @Override
    public LispArrayList add(Datum d) {
        this.list.add(d);
        return this;
    }

    @Override
    public LispArrayList copyDelete(Datum d) {
        return new LispArrayList(this.list).delete(d);
    }

    @Override
    public LispArrayList delete(Datum d) {
        this.list.remove(d);
        return this;
    }

    @Override
    public LispArrayList copyDeleteAll(Datum d) {
        return new LispArrayList(this.list).deleteAll(d);
    }

    @Override
    public LispArrayList deleteAll(Datum d) {
        while (this.list.remove(d)) {
        }
        return this;
    }

    @Override
    public LispArrayList copyAddFrom(LispBag d) {
        return new LispArrayList(this.list).addFrom(d);
    }

    @Override
    public LispArrayList addFrom(LispBag d) {
        if (d instanceof LispArrayList) {
            this.list.addAll(((LispArrayList)d).list);
        } else {
            for (Datum x : d) {
                this.list.add(x);
            }
        }
        return this;
    }

    @Override
    public LispArrayList copyDeleteFrom(LispBag d) {
        return new LispArrayList(this.list).deleteFrom(d);
    }

    @Override
    public LispArrayList deleteFrom(LispBag d) {
        for (Datum x : d) {
            this.list.remove(x);
        }
        return this;
    }

    @Override
    public LispArrayList copyDeleteAllFrom(LispBag d) {
        return new LispArrayList(this.list).deleteAllFrom(d);
    }

    @Override
    public LispArrayList deleteAllFrom(LispBag d) {
        Iterator<Datum> itr = this.list.iterator();
        while (itr.hasNext()) {
            if (!d.contains(itr.next())) continue;
            itr.remove();
        }
        return this;
    }

    @Override
    public Symbol getCollectionName() {
        return ARRAY_LIST;
    }

    @Override
    public Datum toList() {
        return LispUtils.toCons(this.list);
    }

    @Override
    public int count(Datum c2a) {
        int c = 0;
        for (Datum o : this) {
            if (!this.equivalence(o, c2a)) continue;
            ++c;
        }
        return c;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Datum prototype() {
        return new LispArrayList();
    }

    @Override
    public LispArrayList clear() {
        this.list.clear();
        return this;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        if (this.list.size() != col.size()) {
            return false;
        }
        Iterator j = col.iterator();
        int i = 0;
        while (i < this.list.size()) {
            if (!LispUtils.equals(this.list.get(i), (Datum)j.next())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure p, Environment env, LispMessage mesg) {
        if (this.list.size() != col.size()) {
            return false;
        }
        Iterator j = col.iterator();
        int i = 0;
        while (i < this.list.size()) {
            if (!Scheme.callva(p, env, mesg, this.list.get(i), (Datum)j.next()).isTrue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Datum duplicate() {
        return new LispArrayList(this.list);
    }

    @Override
    public boolean contains(Datum d) {
        return this.list.contains(d);
    }

    @Override
    public Iterator<Datum> iterator() {
        return this.list.iterator();
    }

    @Override
    public LispArrayList insertFirst(Datum d) {
        this.list.add(0, d);
        return this;
    }

    @Override
    public LispArrayList insertLast(Datum d) {
        this.list.add(d);
        return this;
    }

    @Override
    public LispArrayList copyInsertFirst(Datum d) {
        return new LispArrayList(this.list).insertFirst(d);
    }

    @Override
    public LispArrayList copyInsertLast(Datum d) {
        return new LispArrayList(this.list).insertLast(d);
    }

    @Override
    public Datum[] removeFirst() {
        return new Datum[]{this, this.list.remove(0)};
    }

    @Override
    public Datum[] removeLast() {
        return new Datum[]{this, this.list.remove(this.list.size() - 1)};
    }

    @Override
    public Datum[] copyWithoutFirst() {
        LispArrayList r = new LispArrayList(this.list);
        return new Datum[]{r, r.list.remove(0)};
    }

    @Override
    public Datum[] copyWithoutLast() {
        LispArrayList r = new LispArrayList(this.list);
        return new Datum[]{r, r.list.remove(r.list.size() - 1)};
    }

    @Override
    public LispArrayList copyInsert(int index, Datum d) {
        return new LispArrayList(this.list).insert(index, d);
    }

    @Override
    public LispArrayList insert(int index, Datum d) {
        this.list.add(index, d);
        return this;
    }

    @Override
    public Datum copyDelete(int index) {
        return new LispArrayList(this.list).delete(index);
    }

    @Override
    public Datum delete(int index) {
        this.list.remove(index);
        return this;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("(array-list");
        for (Datum x : this.list) {
            buf.append(" ").append(LispUtils.print(x));
        }
        buf.append(")");
    }
}

