/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.charset;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.charset.LispCharSet;
import net.morilib.lisp.charset.LispCharSetBuilder;
import net.morilib.range.integer.IntInterval;
import net.morilib.range.integer.IntRangeAdder;

public class LispCharSetRemover
extends Datum2 {
    LispCharSet range;
    List<LispCharSetBuilder.Int2> set;

    LispCharSetRemover(LispCharSet base) {
        if (base == null) {
            throw new NullPointerException();
        }
        this.range = base;
        this.set = new ArrayList<LispCharSetBuilder.Int2>();
        for (IntInterval i : this.range.charset.intervals()) {
            this.set.add(new LispCharSetBuilder.Int2(i.minimum(), i.maximum()));
        }
    }

    public void remove(int c) {
        ListIterator<LispCharSetBuilder.Int2> itr = this.set.listIterator();
        while (itr.hasNext()) {
            LispCharSetBuilder.Int2 x = itr.next();
            if (c == x.left) {
                if (c == x.right) {
                    itr.remove();
                    break;
                }
                ++x.left;
                break;
            }
            if (c == x.right) {
                --x.right;
                break;
            }
            if (x.left >= c || c >= x.right) continue;
            LispCharSetBuilder.Int2 y = new LispCharSetBuilder.Int2(c + 1, x.right);
            x.right = c - 1;
            itr.add(y);
            break;
        }
    }

    public LispCharSet toCharSet() {
        IntRangeAdder r = new IntRangeAdder();
        for (LispCharSetBuilder.Int2 x : this.set) {
            r.add(new IntInterval(x.left, x.right));
        }
        this.range.charset = r.toRange();
        return this.range;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<char-set-remover>");
    }
}

