/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import net.morilib.lisp.Callable;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CodeExecutorFactory;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.CompilerFactory;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ISubr;
import net.morilib.lisp.InitLispLoader;
import net.morilib.lisp.InitSubrLoader;
import net.morilib.lisp.InitVarLoader;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.JavaException;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Parser;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.ReadException;
import net.morilib.lisp.ReadFileException;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.exlib.CommandLine;
import net.morilib.lisp.r6rs.LibraryID;
import net.morilib.lisp.util.LogEnv;
import net.morilib.parser.ParserUtils;
import net.morilib.util.Maps;
import net.morilib.util.SimpleMap;

public final class Scheme {
    public static final int SCHEME_VERSION = 5;
    private static Logger _log = LogEnv.init("schlush.main");
    private static PrintWriter transcript;
    private Environment global;
    private LispCompiler comp;
    private CodeExecutor exec;
    private IntStack memento;
    private Parser parser;
    private LispMessage message;
    private String stackTrace;

    static {
        Environment env = Scheme.newRnRSEnv(5);
        InputStream ins = LibraryID.class.getResourceAsStream("/net/morilib/lisp/init/R5RSenvs.txt");
        SimpleMap<String, Symbol> map = new SimpleMap<String, Symbol>(){

            @Override
            public Symbol map(String key) {
                return Symbol.getSymbol(key);
            }
        };
        List<Symbol> sym = ParserUtils.parseToList(ins, "#", map);
        LibraryID.putNamespace(LibraryID.R5RS, env, Maps.identityMapOf(new HashSet<Symbol>(sym)));
        transcript = null;
    }

    private Scheme(LispMessage msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.global = new Environment();
        this.message = msg;
        this.comp = CompilerFactory.getInstance(this.message);
        this.exec = CodeExecutorFactory.getInstance(this.message);
        this.memento = this.exec.newMemento();
        this.parser = new Parser(this.global, this.message);
    }

    public Scheme(Environment env, LispMessage msg) {
        if (env == null) {
            throw new NullPointerException();
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        this.global = env;
        this.message = msg;
        this.comp = CompilerFactory.getInstance(this.message);
        this.exec = CodeExecutorFactory.getInstance(this.message);
        this.memento = this.exec.newMemento();
        this.parser = new Parser(this.global, this.message);
    }

    public static Scheme newInstance(Locale lc) {
        Scheme res = new Scheme(LispMessage.getInstance(lc));
        InitSubrLoader.load(res.global);
        InitVarLoader.load(res.global);
        res.parser.clear();
        InitLispLoader.load(res);
        res.parser.clear();
        return res;
    }

    public static Scheme newInstance() {
        return Scheme.newInstance(Locale.getDefault());
    }

    public static Environment newNullEnv(int ver) {
        return Scheme.newNull((int)ver).global;
    }

    public static Environment newRnRSEnv(int ver) {
        return Scheme.newRnRS((int)ver).global;
    }

    public static Scheme newEmpty() {
        return new Scheme(LispMessage.getInstance());
    }

    public static Scheme newNull(int ver) {
        Scheme res = new Scheme(LispMessage.getInstance());
        InitSubrLoader.loadNullEnv(res.global, ver);
        InitVarLoader.loadNullEnv(res.global, ver);
        res.parser.clear();
        InitLispLoader.loadNullEnv(res, ver);
        res.parser.clear();
        return res;
    }

    public static Scheme newRnRS(int ver) {
        Scheme res = new Scheme(LispMessage.getInstance());
        InitSubrLoader.loadRnRSEnv(res.global, ver);
        InitVarLoader.loadRnRSEnv(res.global, ver);
        res.parser.clear();
        InitLispLoader.loadRnRSEnv(res, ver);
        res.parser.clear();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTranscript(PrintWriter pw) {
        Class<Scheme> clazz = Scheme.class;
        synchronized (Scheme.class) {
            if (transcript != null) {
                transcript.close();
            }
            transcript = pw;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void loadNull(int ver) {
        InitSubrLoader.loadNullEnv(this.global, ver);
        InitVarLoader.loadNullEnv(this.global, ver);
        this.parser.clear();
        InitLispLoader.loadNullEnv(this, ver);
        this.parser.clear();
    }

    public void loadRnRS(int ver) {
        InitSubrLoader.loadRnRSEnv(this.global, ver);
        InitVarLoader.loadRnRSEnv(this.global, ver);
        this.parser.clear();
        InitLispLoader.loadRnRSEnv(this, ver);
        this.parser.clear();
    }

    public Datum input(Datum sexp) {
        try {
            Datum d = sexp;
            CompiledCode.Builder b = new CompiledCode.Builder();
            long t = System.currentTimeMillis();
            d = this.comp.expandMacro(d, this.global, this.exec, this.memento);
            IntLispUtils.timelog(_log, "Expand Macro : ", t);
            t = System.currentTimeMillis();
            this.comp.compile(d, this.global, b, true, new Cons(), true, new LinkedList<Cons>(), this.exec, this.memento, new LispCompiler.MiscInfo(null));
            b.addReturnOp();
            IntLispUtils.timelog(_log, "Compile : ", t);
            t = System.currentTimeMillis();
            Datum res = this.exec.exec(b.getCodeRef(), this.global, this.memento);
            IntLispUtils.timelog(_log, "Execute : ", t);
            _log.fine(this.memento.toString());
            Datum datum = res;
            return datum;
        }
        finally {
            this.parser.clear();
            this.stackTrace = this.memento.getStackTrace();
            this.memento = this.exec.newMemento();
        }
    }

    public Datum input(String rd) {
        block5: {
            this.parser.read(rd);
            if (this.parser.parse()) break block5;
            return null;
        }
        try {
            Datum d = this.parser.getDatum();
            if (d != null) {
                return this.input(d);
            }
            this.parser.clear();
            return null;
        }
        catch (ReadException e) {
            this.parser.clear();
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public Datum exec(String rd) {
        Datum res = this.input(rd);
        if (res == null) {
            throw new IllegalArgumentException("S-exp is not completed");
        }
        return res;
    }

    public void readFile(Reader rd1) throws IOException {
        PushbackReader rd2 = new PushbackReader(rd1);
        int lineno = 0;
        IntLispUtils.skipShebang(rd2);
        BufferedReader rd = new BufferedReader(rd2);
        try {
            while (true) {
                String read = rd.readLine();
                ++lineno;
                if (read != null) {
                    this.input(read);
                    continue;
                }
                break;
            }
        }
        catch (ReadException e) {
            String ln = this.message.get("err.lineno");
            throw new ReadFileException(String.valueOf(lineno) + ln + ":" + e.getMessage(), e);
        }
        catch (LispException e) {
            String ln = this.message.get("err.lineno");
            throw new ReadFileException(String.valueOf(lineno) + ln + ":" + e.getMessage(), e);
        }
        catch (JavaException e) {
            String ln = this.message.get("err.lineno");
            throw new ReadFileException(String.valueOf(lineno) + ln + ":" + e.getMessage(), e);
        }
        this.parser.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void readEvalPrintLoop(Reader rd1) throws IOException {
        rd = new BufferedReader(rd1);
        block10: while (true) {
            prompt = " >";
            res = null;
            try {
                while (true) {
                    if (res != null) {
                        rep = LispUtils.getResult(res);
                        System.out.println(rep);
                        if (Scheme.transcript == null) continue block10;
                        r2 = Scheme.class;
                        // MONITORENTER : net.morilib.lisp.Scheme.class
                        ** try [egrp 2[TRYBLOCK] [2 : 127->147)] { 
lbl14:
                        // 1 sources

                        break;
                    }
                    System.out.print(prompt);
                    r2 = rd.readLine();
                    if (r2 == null) {
                        return;
                    }
                    if (Scheme.transcript != null) {
                        var7_10 = Scheme.class;
                        // MONITORENTER : net.morilib.lisp.Scheme.class
                        if (Scheme.transcript != null) {
                            Scheme.transcript.print(prompt);
                            Scheme.transcript.println((String)r2);
                        }
                        // MONITOREXIT : var7_10
                    }
                    res = this.input((String)r2);
                    prompt = ">>";
                }
                {
                    if (Scheme.transcript != null) {
                        Scheme.transcript.println(rep);
                    }
                    // MONITOREXIT : r2
                    continue;
                }
lbl38:
                // 1 sources

                catch (Throwable v1) {
                    // MONITOREXIT : r2
                    throw v1;
                }
            }
            catch (ReadException e) {
                System.err.println(String.valueOf(this.message.get("err.repl.read")) + e.getMessage());
                System.err.println(String.valueOf(this.message.get("info.condition")) + e.getCondition().describeShort());
                continue;
            }
            catch (LispException e) {
                tra = this.stackTrace;
                System.err.println(String.valueOf(this.message.get("err.repl.err")) + e.getMessage());
                if (tra != null && !tra.equals("")) {
                    System.err.println(this.message.get("err.stacktrace"));
                    System.err.print(tra);
                }
                if (e.getException() != null) {
                    e.getException().printStackTrace();
                }
                System.err.println(String.valueOf(this.message.get("info.condition")) + e.getCondition().describeShort());
                Scheme._log.fine("Stack trace\n" + tra);
                continue;
            }
            catch (JavaException e) {
                System.err.println(String.valueOf(this.message.get("err.repl.err")) + e.getMessage());
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws IOException {
        Scheme eval = Scheme.newInstance();
        ArrayList<LispString> d1 = new ArrayList<LispString>();
        d1.add(new LispString("schluessel"));
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            d1.add(new LispString(s));
            ++n2;
        }
        CommandLine.commandLine = LispUtils.listToCons(d1);
        if (args.length == 0) {
            eval.readEvalPrintLoop(new InputStreamReader(System.in));
            System.exit(0);
        } else {
            InputStream ins = args[0].equals("-") ? System.in : new FileInputStream(args[0]);
            try {
                eval.readFile(new InputStreamReader(ins));
                System.exit(0);
            }
            catch (ReadFileException e) {
                System.err.println(e.getMessage());
                System.exit(2);
            }
        }
    }

    public void set(String var, Object o) {
        this.global.bindDatum(Symbol.getSymbol(var), LispUtils.toDatum(o));
    }

    public void setDotList(String var, Object cdr, Object ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(LispUtils.toDatum(o));
            ++n2;
        }
        this.global.bindDatum(Symbol.getSymbol(var), b.get(LispUtils.toDatum(cdr)));
    }

    public void setList(String var, Object ... lst) {
        this.setDotList(var, Nil.NIL, lst);
    }

    public void setJavaInstance(String var, Object o) {
        this.global.bindDatum(Symbol.getSymbol(var), new JavaInstance(o));
    }

    public Datum get(String var) {
        return this.global.findDatum(Symbol.getSymbol(var));
    }

    public String getString(String var) {
        Datum d = this.get(var);
        if (d instanceof LispString) {
            return ((LispString)d).getString();
        }
        throw new ClassCastException();
    }

    public BigInteger getExactInteger(String var) {
        Datum d = this.get(var);
        if (d instanceof LispInteger) {
            return d.getBigInteger();
        }
        throw new ClassCastException();
    }

    public int getExactInt(String var) {
        return this.getExactInteger(var).intValue();
    }

    public long getExactLong(String var) {
        return this.getExactInteger(var).longValue();
    }

    public LispNumber getNumber(String var) {
        Datum d = this.get(var);
        if (d instanceof LispNumber) {
            return (LispNumber)d;
        }
        throw new ClassCastException();
    }

    public LispReal getReal(String var) {
        LispNumber n = this.getNumber(var);
        if (n.isReal()) {
            return n.getReal();
        }
        throw new ClassCastException();
    }

    public double getDouble(String var) {
        return this.getReal(var).getRealDouble();
    }

    public int getInt(String var) {
        return this.getReal(var).getBigInteger().intValue();
    }

    public long getLong(String var) {
        return this.getReal(var).getBigInteger().longValue();
    }

    public Object getJavaInstance(String var) {
        Datum d = this.get(var);
        if (d instanceof JavaInstance) {
            return ((JavaInstance)d).getJavaInstance();
        }
        throw new ClassCastException();
    }

    public static Datum call(Procedure proc, Environment env, LispMessage mesg, Datum lst) {
        if (proc instanceof Subr) {
            if (((Subr)proc).createClosureClass(env) == null) {
                return ((Subr)proc).eval(lst, env, mesg);
            }
        } else if (proc instanceof ISubr) {
            return ((ISubr)((Object)proc)).eval(lst, env, mesg);
        }
        CodeExecutor exec = CodeExecutorFactory.getInstance(mesg);
        CompiledCode.Builder cd = new CompiledCode.Builder();
        cd.addPush((Datum)((Object)proc));
        cd.addPush(lst);
        cd.addCall();
        cd.addReturnOp();
        return exec.exec(cd.getCodeRef(), env, exec.newMemento());
    }

    public static Datum callva(Procedure proc, Environment env, LispMessage mesg, Datum ... lst) {
        return Scheme.call(proc, env, mesg, LispUtils.toConsList(lst));
    }

    public static Datum call(Datum proc, Environment env, LispMessage mesg, Datum lst) {
        if (proc instanceof Procedure) {
            return Scheme.call((Procedure)((Object)proc), env, mesg, lst);
        }
        throw mesg.getError("err.require.procedure", proc);
    }

    public static Datum callva(Datum proc, Environment env, LispMessage mesg, Datum ... lst) {
        return Scheme.call(proc, env, mesg, LispUtils.toConsList(lst));
    }

    public Datum call(String var, Object ... lst) {
        CompiledCode.Builder cd = new CompiledCode.Builder();
        Datum fn = this.get(var);
        cd.addPush(fn);
        cd.addPush(LispUtils.toConsList(lst));
        cd.addCall();
        cd.addReturnOp();
        return this.exec.exec(cd.getCodeRef(), this.global, this.memento);
    }

    public String callString(String var, Object ... lst) {
        Datum d = this.call(var, lst);
        if (d instanceof LispString) {
            return ((LispString)d).getString();
        }
        throw new ClassCastException();
    }

    public BigInteger callExactInteger(String var, Object ... lst) {
        Datum d = this.call(var, lst);
        if (d instanceof LispInteger) {
            return d.getBigInteger();
        }
        throw new ClassCastException();
    }

    public int callExactInt(String var, Object ... lst) {
        return this.callExactInteger(var, lst).intValue();
    }

    public long callExactLong(String var, Object ... lst) {
        return this.callExactInteger(var, lst).longValue();
    }

    public LispNumber callNumber(String var, Object ... lst) {
        Datum d = this.call(var, lst);
        if (d instanceof LispNumber) {
            return (LispNumber)d;
        }
        throw new ClassCastException();
    }

    public LispReal callReal(String var, Object ... lst) {
        LispNumber n = this.callNumber(var, lst);
        if (n.isReal()) {
            return n.getReal();
        }
        throw new ClassCastException();
    }

    public double callDouble(String var, Object ... lst) {
        return this.callReal(var, lst).getRealDouble();
    }

    public int callInt(String var, Object ... lst) {
        return this.callReal(var, lst).getBigInteger().intValue();
    }

    public long callLong(String var, Object ... lst) {
        return this.callReal(var, lst).getBigInteger().longValue();
    }

    public InputPort createInputPort(Reader rd) {
        return new InputPort(rd, this.message);
    }

    public OutputPort createOutputPort(OutputStream wr) {
        return new OutputPort(wr, this.message);
    }

    public Datum call(Datum cl, Datum ... data) {
        CompiledCode.Builder cd = new CompiledCode.Builder();
        if (!(cl instanceof Callable)) {
            throw new ClassCastException();
        }
        cd.addPush(cl);
        cd.addPush(LispUtils.toConsList(data));
        cd.addCall();
        cd.addReturnOp();
        return this.exec.exec(cd.getCodeRef(), this.global, this.memento);
    }

    public LispMessage getMessage() {
        return this.message;
    }
}

