/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import net.morilib.lang.DoubleUtils;
import net.morilib.util.BitUtils;

public final class Half
extends Number
implements Comparable<Half> {
    private static final int EMAX = 31;
    private static final int EXPBIT = 10;
    private static final short EXPMASK = 31744;
    private static final short SIGMASK = 1023;
    private static final short SGNMASK = Short.MIN_VALUE;
    public static final int MAX_EXPONENT = 15;
    public static final int MIN_NORMALIZED_EXPONENT = -14;
    public static final int MIN_EXPONENT = -24;
    public static final int FRACTION_BITS = 10;
    public static final int BIAS = 15;
    public static final short POSITIVE_INFINITY_BY_SHORT = 31744;
    public static final short NEGATIVE_INFINITY_BY_SHORT = -1024;
    public static final short MAX_VALUE_BY_SHORT = 31743;
    public static final short NEGATIVE_MAX_VALUE_BY_SHORT = -1025;
    public static final short MIN_VALUE_BY_SHORT = 1;
    public static final short ZERO_BY_SHORT = 0;
    public static final short MINUS_ZERO_BY_SHORT = Short.MIN_VALUE;
    public static final short NaN_BY_SHORT = Short.MAX_VALUE;
    public static final Half MAX_VALUE = new Half(31743);
    public static final Half NEGATIVE_MAX_VALUE = new Half(-1025);
    public static final Half MIN_VALUE = new Half(1);
    public static final int SIZE = 16;
    private short value;

    static short _getHalf(int sign, int exp, int frac) {
        int l = 0;
        l |= sign == 1 ? Short.MIN_VALUE : 0;
        if (exp > 15) {
            return (short)(l | 0x7C00);
        }
        if (exp >= -14) {
            l |= (exp + 15 & 0x1F) << 10;
        } else {
            if (exp < -24) {
                return (short)l;
            }
            l |= frac << exp - -24 & 0x3FF;
            l |= 1 << exp - -24;
        }
        return (short)(l |= frac & 0x3FF);
    }

    public static int getSignumField(short x) {
        return x < 0 ? 1 : 0;
    }

    public static int getExponentField(short x) {
        return (x & 0x7C00) >> 10;
    }

    public static int getFractionField(int x) {
        return x & 0x3FF;
    }

    public static int getSignum(short x) {
        if (Half.isZero(x)) {
            return 0;
        }
        return Half.getSignumField(x) == 0 ? 1 : -1;
    }

    public static int getExponent(short x) {
        int e = Half.getExponentField(x);
        int f = Half.getFractionField(x);
        if (Half.isZero(x)) {
            return 0;
        }
        if (e == 31) {
            if (f == 0) {
                return 16;
            }
            return Integer.MIN_VALUE;
        }
        if (e > 0) {
            return e - 15;
        }
        return -24 + (BitUtils.getMsb(f) - 1);
    }

    public static boolean isNormalized(short x) {
        int e = Half.getExponentField(x);
        return e > 0 && e < 31;
    }

    public static boolean isNaN(short x) {
        return Half.getExponent(x) == Integer.MIN_VALUE;
    }

    public static boolean isZero(short x) {
        return (x & Short.MAX_VALUE) == 0;
    }

    public static boolean isInfinite(short x) {
        return Half.getExponentField(x) == 31 && Half.getFractionField(x) == 0;
    }

    public static short inclement(short l) {
        int s = Half.getSignumField(l);
        int e = Half.getExponent(l);
        int f = Half.getFractionField(l);
        if (l == 31744) {
            return l;
        }
        if (l == -1024) {
            return -1025;
        }
        if (l == 31743) {
            return 31744;
        }
        if (Half.isNaN(l)) {
            return l;
        }
        if (f == 1023) {
            return Half._getHalf(s, e + 1, 0);
        }
        return Half._getHalf(s, e, f + 1);
    }

    public static short declement(short l) {
        int s = Half.getSignumField(l);
        int e = Half.getExponent(l);
        int f = Half.getFractionField(l);
        if (l == 31744) {
            return 31743;
        }
        if (l == -1024) {
            return l;
        }
        if (l == -1025) {
            return -1024;
        }
        if (Half.isNaN(l)) {
            return l;
        }
        if ((long)f == 0L) {
            return Half._getHalf(s, e - 1, 1023);
        }
        return Half._getHalf(s, e, f - 1);
    }

    public static int compare(short a, short b) {
        int as = Half.getSignum(a);
        int bs = Half.getSignum(b);
        int ea = Half.getExponent(a);
        int eb = Half.getExponent(b);
        int fa = Half.getFractionField(a);
        int fb = Half.getFractionField(b);
        if (Half.isNaN(a)) {
            return Half.isNaN(b) ? 0 : 1;
        }
        if (Half.isNaN(b)) {
            return -1;
        }
        if (as > bs) {
            return 1;
        }
        if (as < bs) {
            return -1;
        }
        if (ea > eb) {
            return 1;
        }
        if (ea < eb) {
            return -1;
        }
        if (fa > fb) {
            return 1;
        }
        if (fa < fb) {
            return -1;
        }
        return 0;
    }

    public static boolean equals(short a, short b) {
        return Half.isZero(a) && Half.isZero(b) || a == b;
    }

    public static short max(short a, short b) {
        return Half.compare(a, b) > 0 ? a : b;
    }

    public static short min(short a, short b) {
        return Half.compare(a, b) < 0 ? a : b;
    }

    private static short unnormalizedToF(int a) {
        int b = BitUtils.getMsb(a);
        if (b > 10) {
            int e = b - 10 + -14 - 1;
            short r = Half._getHalf(0, e, a >> e - -14 & 0x3FF);
            return r;
        }
        return (short)a;
    }

    private static short addsamesign(short a, short b) {
        int as = Half.getSignumField(a);
        int ea = Half.getExponent(a);
        int eb = Half.getExponent(b);
        int fa = Half.getFractionField(a);
        int fb = Half.getFractionField(b);
        if (ea - eb > 10) {
            return a;
        }
        if (ea - eb == 10) {
            if ((fb & 0x200) > 0) {
                return Half.inclement(a);
            }
            return a;
        }
        if (!Half.isNormalized(a)) {
            int an = Half.unnormalizedToF(fa + fb);
            return (short)(an |= as > 0 ? Short.MIN_VALUE : 0);
        }
        if (!Half.isNormalized(b)) {
            int an = (fa | 0x400) << ea - -24 - 10;
            an += fb;
            return Half.unnormalizedToF(an |= as > 0 ? Short.MIN_VALUE : 0);
        }
        int an = (fa | 0x400) << 10;
        int bn = (fb | 0x400) << 10 - (ea - eb);
        int cr = (an += bn) >> 21;
        an >>= 10 + cr;
        return Half._getHalf(as, ea + cr, an &= 0x3FF);
    }

    private static short adddiffsign(short a, short b) {
        int as = Half.getSignumField(a);
        int ea = Half.getExponent(a);
        int eb = Half.getExponent(b);
        int fa = Half.getFractionField(a);
        int fb = Half.getFractionField(b);
        if (ea - eb > 10) {
            return a;
        }
        if (ea - eb == 10) {
            if ((fb & 0x200) > 0) {
                return Half.declement(a);
            }
            return a;
        }
        if (!Half.isNormalized(a)) {
            int an = fa - fb;
            return (short)(an |= as > 0 ? Short.MIN_VALUE : 0);
        }
        if (!Half.isNormalized(b)) {
            int an = (fa | 0x400) << ea - -24 - 10;
            an -= fb;
            return (short)(an |= as > 0 ? Short.MIN_VALUE : 0);
        }
        int an = (fa | 0x400) << 10;
        int bn = (fb | 0x400) << 10 - (ea - eb);
        if ((an -= bn) > 0) {
            int cr = (an & 0x100000) > 0 ? 0 : 1;
            return Half._getHalf(as, ea - cr, (an >>= 8) >> 1);
        }
        return 0;
    }

    public static short neg(short a) {
        if (Half.isNaN(a)) {
            return Short.MAX_VALUE;
        }
        return (short)(a ^ Short.MIN_VALUE);
    }

    public static short abs(short a) {
        if (Half.isNaN(a)) {
            return Short.MAX_VALUE;
        }
        return (short)(a & Short.MAX_VALUE);
    }

    public static short add(short a, short b) {
        int as = Half.getSignumField(a);
        int bs = Half.getSignumField(b);
        short za = Half.abs(a);
        short zb = Half.abs(b);
        if (Half.isNaN(a) || Half.isNaN(b)) {
            return Short.MAX_VALUE;
        }
        if (a == 31744) {
            return b == -1024 ? (short)Short.MAX_VALUE : (short)a;
        }
        if (a == -1024) {
            return b == 31744 ? (short)Short.MAX_VALUE : (short)a;
        }
        if (as == bs) {
            return Half.compare(za, zb) > 0 ? Half.addsamesign(a, b) : Half.addsamesign(b, a);
        }
        return Half.compare(za, zb) > 0 ? Half.adddiffsign(a, b) : Half.adddiffsign(b, a);
    }

    public static short sub(short a, short b) {
        int as = Half.getSignumField(a);
        int bs = Half.getSignumField(b);
        short za = Half.abs(a);
        short zb = Half.abs(b);
        if (Half.isNaN(a) || Half.isNaN(b)) {
            return Short.MAX_VALUE;
        }
        if (a == 31744) {
            return b == 31744 ? (short)Short.MAX_VALUE : (short)a;
        }
        if (a == -1024) {
            return b == -1024 ? (short)Short.MAX_VALUE : (short)a;
        }
        if (as == bs) {
            return Half.compare(za, zb) > 0 ? Half.adddiffsign(a, Half.neg(b)) : Half.adddiffsign(Half.neg(b), a);
        }
        return Half.compare(za, zb) > 0 ? Half.addsamesign(a, Half.neg(b)) : Half.addsamesign(Half.neg(b), a);
    }

    public static short mul(short a, short b) {
        int sg = Half.getSignumField(a) ^ Half.getSignumField(b);
        int ea = Half.getExponent(a);
        int eb = Half.getExponent(b);
        int fa = Half.getFractionField(a);
        int fb = Half.getFractionField(b);
        if (Half.isNaN(a) || Half.isNaN(b)) {
            return Short.MAX_VALUE;
        }
        if (Half.isInfinite(a)) {
            switch (Half.getSignum(b)) {
                case -1: {
                    return Half.neg(a);
                }
                case 0: {
                    return sg > 0 ? (short)0 : Short.MIN_VALUE;
                }
                case 1: {
                    return a;
                }
            }
            throw new RuntimeException();
        }
        if (ea + eb > 15) {
            if (sg > 0) {
                return -1024;
            }
            return 31744;
        }
        if (ea + eb < -24) {
            return sg > 0 ? (short)Short.MIN_VALUE : 0;
        }
        if (Half.isNormalized(a) && Half.isNormalized(b)) {
            int an = (fa | 0x400) * (fb | 0x400);
            int bt = BitUtils.getMsb(an);
            an >>= bt - 10 - 1;
            bt = bt - 20 - 1;
            return Half._getHalf(sg, ea + eb + bt, an &= 0x3FF);
        }
        if (Half.isNormalized(a) || Half.isNormalized(b)) {
            int an;
            if (Half.isNormalized(a)) {
                an = (fa | 0x400) * fb;
            } else {
                an = fa * (fb | 0x400);
                ea = eb;
            }
            int bt = BitUtils.getMsb(an);
            an >>= bt - 10 - 1;
            bt = bt - 10 - 1;
            return Half._getHalf(sg, ea + -24 + bt, an &= 0x3FF);
        }
        throw new RuntimeException();
    }

    public static short div(short a, short b) {
        int sg = Half.getSignumField(a) ^ Half.getSignumField(b);
        int ea = Half.getExponent(a);
        int eb = Half.getExponent(b);
        int fa = Half.getFractionField(a);
        int fb = Half.getFractionField(b);
        if (Half.isNaN(a) || Half.isNaN(b)) {
            return Short.MAX_VALUE;
        }
        if (Half.isZero(b)) {
            switch (Half.getSignum(a) * (Half.getSignumField(b) > 0 ? -1 : 1)) {
                case -1: {
                    return -1024;
                }
                case 0: {
                    return Short.MAX_VALUE;
                }
                case 1: {
                    return 31744;
                }
            }
            throw new RuntimeException();
        }
        if (Half.isInfinite(b)) {
            if (Half.isInfinite(a)) {
                return Short.MAX_VALUE;
            }
            return sg > 0 ? (short)Short.MIN_VALUE : 0;
        }
        if (ea - eb > 15) {
            if (sg > 0) {
                return -1024;
            }
            return 31744;
        }
        if (ea - eb < -24) {
            return sg > 0 ? (short)Short.MIN_VALUE : 0;
        }
        if (Half.isNormalized(b)) {
            int an = Half.isNormalized(a) ? (fa | 0x400) << 11 : fa << 12;
            int bt = BitUtils.getMsb(an /= fb | 0x400);
            if (ea - eb >= -14) {
                an >>= bt - 10 - 1;
                bt = bt - 10 - 2;
                return Half._getHalf(sg, ea - eb + bt, an &= 0x3FF);
            }
            an >>= 11 - (ea - eb - -24);
            an &= 0x3FF;
            an = Half.unnormalizedToF(an);
            an = sg > 0 ? an | Short.MIN_VALUE : an;
            return (short)an;
        }
        if (Half.isNormalized(a)) {
            int an = ((fa | 0x400) << 11) / fb;
            int bt = BitUtils.getMsb(an);
            an >>= bt - 10 - 1;
            bt = bt - 10 - 2;
            bt = bt + ea - -14;
            return Half._getHalf(sg, bt, an &= 0x3FF);
        }
        int an = fa << 10;
        int bt = BitUtils.getMsb(an /= fb);
        if (bt <= 10) {
            an <<= 10 - bt + 1;
            return Half._getHalf(sg, -(10 - bt + 1), an &= 0x3FF);
        }
        an >>= -(10 - bt + 1);
        return Half._getHalf(sg, -(10 - bt + 1), an &= 0x3FF);
    }

    public static double toDouble(short a) {
        int as = Half.getSignumField(a);
        int ea = Half.getExponent(a);
        int fa = Half.getFractionField(a);
        long l = fa;
        if (Half.isNaN(a)) {
            return Double.NaN;
        }
        if (Half.isInfinite(a)) {
            if (as > 0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (Half.isZero(a)) {
            return as > 0 ? 0.0 : -0.0;
        }
        if (ea < -14) {
            l <<= 42;
            return DoubleUtils._getDouble(as, ea, l <<= 15 - ea + 1);
        }
        return DoubleUtils._getDouble(as, ea, l <<= 42);
    }

    public static float toFloat(short a) {
        return (float)Half.toDouble(a);
    }

    public static String toString(short a) {
        return Double.toString(Half.toDouble(a));
    }

    public static String toHexString(short a) {
        return Double.toHexString(Half.toDouble(a));
    }

    public static short parseHalf(String s) {
        return DoubleUtils.toHalf(Double.parseDouble(s));
    }

    public static short ulp(short a) {
        int e = Half.getExponent(a);
        if (Half.isNaN(a)) {
            return a;
        }
        if (Half.isInfinite(a)) {
            return 31744;
        }
        if (a == 31743 || a == -1025) {
            return Half._getHalf(0, 5, 0);
        }
        if (Half.isZero(a)) {
            return 1;
        }
        if (!Half.isNormalized(a)) {
            return 1;
        }
        return Half._getHalf(0, e - 10, 0);
    }

    public Half(short value) {
        this.value = value;
    }

    public Half(double value) {
        this.value = DoubleUtils.toHalf(value);
    }

    public Half(String s) {
        this.value = Half.parseHalf(s);
    }

    public short toShortValue() {
        return this.value;
    }

    public boolean isInfinite() {
        return Half.isInfinite(this.value);
    }

    public boolean isNaN() {
        return Half.isNaN(this.value);
    }

    @Override
    public int compareTo(Half o) {
        return Half.compare(this.value, o.value);
    }

    @Override
    public int intValue() {
        return (int)Half.toDouble(this.value);
    }

    @Override
    public long longValue() {
        return (long)Half.toDouble(this.value);
    }

    @Override
    public float floatValue() {
        return (float)Half.toDouble(this.value);
    }

    @Override
    public double doubleValue() {
        return Half.toDouble(this.value);
    }

    public boolean equals(Object o) {
        if (o instanceof Half) {
            return this.value == ((Half)o).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Half.toString(this.value);
    }
}

