/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.morilib.automata.TextBound;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAState;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public abstract class CompoundNFA<T, A, B>
extends NFAObject<T, A, B> {
    protected List<NFAObject<T, A, B>> nfas;

    @Override
    void addStates(Set<NFAState> res, NFAState state, T alphabet) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                this.nfas.get(i).addStates(res, state, alphabet);
                return;
            }
            ++i;
        }
    }

    @Override
    void addStates(Set<NFAState> res, NFAState state, Range a) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                this.nfas.get(i).addStates(res, state, a);
                return;
            }
            ++i;
        }
    }

    @Override
    void addStatesBound(Set<NFAState> res, NFAState state, EnumSet<TextBound> a) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                this.nfas.get(i).addStatesBound(res, state, a);
                return;
            }
            ++i;
        }
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                return this.nfas.get(i).nextAlphabets(state);
            }
            ++i;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        HashSet res = new HashSet();
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                res.addAll(this.nfas.get(i).getMatchTag(state));
            }
            ++i;
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        HashSet res = new HashSet();
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                res.addAll(this.nfas.get(i).getMatchTagEnd(state));
            }
            ++i;
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<A> getAccept(NFAState state) {
        HashSet res = new HashSet();
        int i = 0;
        while (i < this.nfas.size()) {
            if (this.nfas.get(i).isState(state)) {
                res.addAll(this.nfas.get(i).getAccept(state));
            }
            ++i;
        }
        return Collections.unmodifiableSet(res);
    }
}

