/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.painter;

import java.util.List;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.painter.drawer.ImageDrawer;
import net.morilib.lisp.swing.GUIElement;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2010/12/18
 */
public class DrawImage extends Subr {
	
	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(
			Datum body, Environment env, LispMessage mesg) {
		List<Datum> l = LispUtils.consToList(body, mesg);
		
		if(l.size() == 4) {
			if(!(l.get(0) instanceof SchlushFrame) &&
					!(l.get(0) instanceof GUIElement)) {
				throw mesg.getError(
						"err.swing.require.canvas", l.get(0));
			} else if(!(l.get(1) instanceof ILispImage)) {
				throw mesg.getError(
						"err.swing.require.image", l.get(1));
			}
			LispUtils.checkReal(l.get(2), mesg);
			LispUtils.checkReal(l.get(3), mesg);
		}
		
		((SchlushFrame)l.get(0)).addDrawer(new ImageDrawer(
				((ILispImage)l.get(1)).getImage(),
				l.get(2).getRealDouble(),
				l.get(3).getRealDouble(),
				((GUIElement)l.get(0)).getAWTComponent()));
		return Undef.UNDEF;
	}

}
