/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.datetime.cjkv;

import net.morilib.calendar.cjkv.CJKVEra;
import net.morilib.calendar.cjkv.JapaneseEras;
import net.morilib.lisp.Datum2;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/01/28
 */
public class LispCJKVEra extends Datum2 {

	/**
	 * 
	 */
	public static final LispCJKVEra HEISEI =
		new LispCJKVEra(JapaneseEras.HEISEI);

	/**
	 * 
	 */
	public static final LispCJKVEra SHOWA =
		new LispCJKVEra(JapaneseEras.SHOWA);

	/**
	 * 
	 */
	public static final LispCJKVEra TAISHO =
		new LispCJKVEra(JapaneseEras.TAISHO);

	/**
	 * 
	 */
	public static final LispCJKVEra MEIJI =
		new LispCJKVEra(JapaneseEras.MEIJI);

	//
	CJKVEra era;

	/**
	 * 
	 * @param era
	 */
	public LispCJKVEra(CJKVEra era) {
		this.era = era;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum2#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<cjkv-era ").append(era.toString()).append(">");
	}

}
