/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.Bytes;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;
import net.morilib.util.uvector.UniformArray;

public class IntArray
extends AbstractUniformArray
implements Serializable {
    private int[] array;
    private UniformArray.TypeAttr signed;

    private IntArray(int[] arr, UniformArray.TypeAttr attr) {
        if (!attr.isExact()) {
            throw new IllegalArgumentException(attr.toString());
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new int[arr.length];
        this.signed = attr;
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public IntArray(IntArray a) {
        this.array = Arrays2.copy(a.array);
        this.signed = a.signed;
    }

    public static IntArray newArray(int[] arr) {
        return new IntArray(arr, UniformArray.TypeAttr.SIGNED_INT);
    }

    public static IntArray newuArray(int[] arr) {
        return new IntArray(arr, UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public static IntArray malloc(int size) {
        return new IntArray(new int[size], UniformArray.TypeAttr.SIGNED_INT);
    }

    public static IntArray mallocu(int size) {
        return new IntArray(new int[size], UniformArray.TypeAttr.UNSIGNED_INT);
    }

    @Override
    public byte getByte(int i) {
        int r = this.getInt(i);
        return (byte)r;
    }

    @Override
    public double getDouble(int i) {
        return this.getLong(i);
    }

    @Override
    public float getFloat(int i) {
        return this.getLong(i);
    }

    @Override
    public int getInt(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    @Override
    public long getLong(int i) {
        int r = this.getInt(i);
        return this.signed.isSigned() ? (long)r : Bytes.uintToLong(r);
    }

    @Override
    public short getShort(int i) {
        int r = this.getInt(i);
        return (short)r;
    }

    @Override
    public void setByte(int i, byte x) {
        this.setInt(i, this.signed.isSigned() ? x : Bytes.ubyteToInt((byte)x));
    }

    @Override
    public void setDouble(int i, double x) {
        this.setLong(i, (long)x);
    }

    @Override
    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    @Override
    public void setInt(int i, int x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    @Override
    public void setLong(int i, long x) {
        this.setInt(i, (int)x);
    }

    @Override
    public void setShort(int i, short x) {
        this.setInt(i, this.signed.isSigned() ? x : Bytes.ushortToInt((short)x));
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 2];
        int i = 0;
        while (i < this.array.length) {
            e.writeInt(res, i << 2, this.array[i]);
            ++i;
        }
        return res;
    }

    public int[] toArray() {
        return Arrays2.copy(this.array);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntArray) {
            return Arrays.equals(this.array, ((IntArray)obj).array);
        }
        return false;
    }
}

