/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range.integer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import net.morilib.range.integer.AbstractIntRange;
import net.morilib.range.integer.IntRange;

public class IntInterval
extends AbstractIntRange
implements Comparable<IntInterval>,
Serializable {
    int left;
    int right;

    public IntInterval(int left, int right) {
        if (left > right) {
            throw new IllegalArgumentException();
        }
        this.left = left;
        this.right = right;
    }

    IntInterval(boolean f) {
        this.left = Integer.MAX_VALUE;
        this.right = Integer.MIN_VALUE;
    }

    @Override
    public boolean contains(int x) {
        return this.left <= x && x <= this.right;
    }

    @Override
    public boolean containsAll(IntRange r) {
        return this.left <= r.minimum() && r.maximum() <= this.right;
    }

    @Override
    public boolean containsAny(IntRange r) {
        for (IntInterval i : r.intervals()) {
            if (i.left > this.right || i.right < this.left) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIndependent(IntRange r) {
        for (IntInterval i : r.intervals()) {
            if (i.right > this.left && i.left < this.right) continue;
            return true;
        }
        return false;
    }

    @Override
    public int minimum() {
        return this.left;
    }

    @Override
    public int maximum() {
        return this.right;
    }

    @Override
    public Collection<IntInterval> intervals() {
        if (this.left > this.right) {
            return Collections.emptySet();
        }
        return Collections.singleton(this);
    }

    @Override
    public long cardinality() {
        return this.left > this.right ? 0L : (long)this.right - (long)this.left + 1L;
    }

    @Override
    public int compareTo(IntInterval o) {
        if (this.left < o.left) {
            return -1;
        }
        if (this.left > o.left) {
            return 1;
        }
        if (this.right < o.right) {
            return -1;
        }
        if (this.right > o.right) {
            return 1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.left);
        r = 37 * (r + this.right);
        return r;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IntInterval) {
            IntInterval i = (IntInterval)o;
            return this.left == i.left && this.right == i.right;
        }
        return false;
    }
}

