/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.phys.unit;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.morilib.phys.unit.Quantity;
import net.morilib.phys.unit.Unit;
import net.morilib.phys.unit.Units;

public class UnitSystem
implements Serializable {
    private static final String NUMS = "0123456789.";
    Map<String, Quantity> units = new HashMap<String, Quantity>();
    Map<String, String> bases = new HashMap<String, String>();

    protected static void load(UnitSystem un, InputStream ins) throws IOException {
        Quantity q;
        String t;
        String s;
        Properties pp = new Properties();
        pp.load(ins);
        for (Object o : pp.keySet()) {
            s = "" + o;
            t = pp.getProperty(s);
            if (NUMS.indexOf(t.charAt(0)) >= 0 || t.indexOf(42) >= 0 || t.indexOf(94) >= 0 || t.indexOf(47) >= 0) continue;
            un.units.put(s, new Quantity(t));
            un.bases.put(t, s);
        }
        for (Object o : pp.keySet()) {
            s = "" + o;
            t = pp.getProperty(s);
            if (NUMS.indexOf(t.charAt(0)) >= 0 || t.indexOf(42) < 0 && t.indexOf(94) < 0 && t.indexOf(47) < 0 || (q = Units.parse(un, t)) == null) continue;
            un.units.put(s, q);
        }
        for (Object o : pp.keySet()) {
            s = "" + o;
            t = pp.getProperty(s);
            if (NUMS.indexOf(t.charAt(0)) < 0 || (q = Quantity.parse(un, t)) == null) continue;
            un.units.put(s, q);
        }
    }

    public static UnitSystem load(InputStream ins) {
        UnitSystem un = new UnitSystem();
        try {
            UnitSystem.load(un, ins);
            return un;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static UnitSystem loadResource(String s) {
        InputStream ins = UnitSystem.class.getResourceAsStream(s);
        return ins == null ? null : UnitSystem.load(ins);
    }

    public static UnitSystem loadFile(String s) {
        try {
            FileInputStream ins = new FileInputStream(s);
            return ins == null ? null : UnitSystem.load(ins);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    UnitSystem() {
    }

    public Unit getUnit(String s) {
        return this.units.get(s).getUnit();
    }

    public double getCoefficient(String s) {
        return this.units.get(s).getValue();
    }

    public Quantity getQuantity(String s) {
        return this.units.get(s);
    }

    public String getDescription(Unit u) {
        String s = null;
        String t = null;
        int d = Integer.MAX_VALUE;
        for (Map.Entry<String, Quantity> e : this.units.entrySet()) {
            int f;
            if (e.getValue().getValue() != 1.0) continue;
            if (e.getValue().getUnit().equals(u)) {
                return e.getKey();
            }
            if (!e.getValue().getUnit().isSingleDerivedUnit() || Math.abs(f = e.getValue().getUnit().getSingleDerivedIndex()) >= d) continue;
            s = e.getKey();
            t = e.getValue().getUnit().toString();
            d = Math.abs(f);
        }
        return s != null ? String.valueOf(s) + "*" + t : u.toString();
    }
}

