/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.json;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.morilib.parser.json.JSONParseException;
import net.morilib.parser.json.JSONParseHandler;

public class JSONParser {
    private static boolean isws(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    private static boolean isdelimiter(int c) {
        return c == 93 || c == 125 || c == 44 || c == 58;
    }

    private static int skipws(Readable rd) throws IOException {
        int c = 0;
        while ((c = rd.read()) >= 0) {
            if (JSONParser.isws(c)) continue;
            return c;
        }
        return -1;
    }

    private static int skipws(int ch, Readable rd) throws IOException {
        return JSONParser.isdelimiter(ch) ? ch : JSONParser.skipws(rd);
    }

    private static int noteof(Readable rd) throws JSONParseException, IOException {
        int c = rd.read();
        if (c < 0) {
            throw new JSONParseException("invalid EOF");
        }
        return c;
    }

    private static int readhex(Readable rd) throws JSONParseException, IOException {
        int c = rd.read();
        if (c < 0) {
            throw new JSONParseException("invalid EOF");
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        throw new JSONParseException("invalid character" + (char)c);
    }

    private static BigInteger getinteger(int sign, String s) throws JSONParseException {
        if (s.isEmpty()) {
            throw new JSONParseException("invalid character");
        }
        return sign < 0 ? new BigInteger(s).negate() : new BigInteger(s);
    }

    private static BigDecimal getfraction(int sign, String d, String f) throws JSONParseException {
        if (f.isEmpty()) {
            throw new JSONParseException("invalid character");
        }
        String s = String.valueOf(d) + "." + f;
        return sign < 0 ? new BigDecimal(s).negate() : new BigDecimal(s);
    }

    private static BigDecimal getfraction(int sign, String d, String f, int signe, String e) throws JSONParseException {
        if (e.isEmpty() || f.isEmpty() && d.isEmpty()) {
            throw new JSONParseException("invalid character");
        }
        String s = String.valueOf(f.isEmpty() ? d : String.valueOf(d) + "." + f) + "e" + (signe < 0 ? "-" : "+") + e;
        return sign < 0 ? new BigDecimal(s).negate() : new BigDecimal(s);
    }

    private static Object parse(Readable rd, JSONParseHandler h) throws JSONParseException, IOException {
        State st = State.INIT;
        StringBuilder b = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        StringBuilder b3 = new StringBuilder();
        Stack<State> ss = new Stack<State>();
        int c = 0;
        int sign = 1;
        int singe = 1;
        int quot = -1;
        boolean empty = false;
        ss.push(State.INIT);
        h.begin();
        while (!ss.isEmpty()) {
            switch (st) {
                case INIT: {
                    c = JSONParser.skipws(rd);
                    if (c < 0) {
                        return h.eof();
                    }
                    if (c == 91) {
                        h.beginArray();
                        st = State.ARRAY;
                        ss.push(State.ARRAY_SEP);
                        empty = true;
                        break;
                    }
                    if (c == 123) {
                        h.beginObject();
                        st = State.OBJECT;
                        ss.push(State.OBJECT_KEYSEP);
                        empty = true;
                        break;
                    }
                    if (c == 34 || c == 39) {
                        quot = c;
                        st = State.STRING;
                        break;
                    }
                    if (c == 45) {
                        sign = -1;
                        st = State.NUMBER;
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        sign = 1;
                        b.append((char)c);
                        st = State.NUMBER;
                        break;
                    }
                    if (c == 46) {
                        sign = 1;
                        st = State.NUMBER_FRAC;
                        break;
                    }
                    if (Character.isLowerCase(c)) {
                        b.append((char)c);
                        st = State.LITERAL;
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case ARRAY: {
                    c = JSONParser.skipws(rd);
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == 91) {
                        h.beginArray();
                        st = State.ARRAY;
                        ss.push(State.ARRAY_SEP);
                        empty = true;
                        break;
                    }
                    if (c == 123) {
                        h.beginObject();
                        st = State.OBJECT;
                        ss.push(State.OBJECT_KEYSEP);
                        empty = true;
                        break;
                    }
                    if (c == 34 || c == 39) {
                        quot = c;
                        st = State.STRING;
                        break;
                    }
                    if (c == 45) {
                        sign = -1;
                        st = State.NUMBER;
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        sign = 1;
                        b.append((char)c);
                        st = State.NUMBER;
                        break;
                    }
                    if (c == 46) {
                        sign = 1;
                        st = State.NUMBER_FRAC;
                        break;
                    }
                    if (Character.isLowerCase(c)) {
                        b.append((char)c);
                        st = State.LITERAL;
                        break;
                    }
                    if (c == 93 && empty) {
                        h.emptyArray();
                        ss.pop();
                        st = (State)((Object)ss.pop());
                        c = rd.read();
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case ARRAY_SEP: {
                    c = JSONParser.skipws(c, rd);
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == 44) {
                        h.nextArray();
                        st = State.ARRAY;
                        ss.push(State.ARRAY_SEP);
                        empty = false;
                        break;
                    }
                    if (c == 93) {
                        h.endArray();
                        st = (State)((Object)ss.pop());
                        c = rd.read();
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case OBJECT: {
                    c = JSONParser.skipws(rd);
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == 91) {
                        h.beginArray();
                        st = State.ARRAY;
                        ss.push(State.ARRAY_SEP);
                        empty = true;
                        break;
                    }
                    if (c == 123) {
                        h.beginObject();
                        st = State.OBJECT;
                        ss.push(State.OBJECT_KEYSEP);
                        empty = true;
                        break;
                    }
                    if (c == 34 || c == 39) {
                        quot = c;
                        st = State.STRING;
                        break;
                    }
                    if (c == 45) {
                        sign = -1;
                        st = State.NUMBER;
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        sign = 1;
                        b.append((char)c);
                        st = State.NUMBER;
                        break;
                    }
                    if (c == 46) {
                        sign = 1;
                        st = State.NUMBER_FRAC;
                        break;
                    }
                    if (Character.isLowerCase(c)) {
                        b.append((char)c);
                        st = State.LITERAL;
                        break;
                    }
                    if (c == 125 && empty) {
                        h.emptyObject();
                        ss.pop();
                        st = (State)((Object)ss.pop());
                        c = rd.read();
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case OBJECT_KEYSEP: {
                    c = JSONParser.skipws(c, rd);
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == 58) {
                        h.nextValue();
                        st = State.OBJECT_VALUE;
                        ss.push(State.OBJECT_SEP);
                        empty = false;
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case OBJECT_VALUE: {
                    c = JSONParser.skipws(rd);
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == 91) {
                        h.beginArray();
                        st = State.ARRAY;
                        ss.push(State.ARRAY_SEP);
                        empty = true;
                        break;
                    }
                    if (c == 123) {
                        h.beginObject();
                        st = State.OBJECT;
                        ss.push(State.OBJECT_KEYSEP);
                        empty = true;
                        break;
                    }
                    if (c == 34 || c == 39) {
                        quot = c;
                        st = State.STRING;
                        break;
                    }
                    if (c == 45) {
                        sign = -1;
                        st = State.NUMBER;
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        sign = 1;
                        b.append((char)c);
                        st = State.NUMBER;
                        break;
                    }
                    if (c == 46) {
                        sign = 1;
                        st = State.NUMBER_FRAC;
                        break;
                    }
                    if (Character.isLowerCase(c)) {
                        b.append((char)c);
                        st = State.LITERAL;
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case OBJECT_SEP: {
                    c = JSONParser.skipws(c, rd);
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == 44) {
                        h.nextObject();
                        st = State.OBJECT;
                        ss.push(State.OBJECT_KEYSEP);
                        empty = false;
                        break;
                    }
                    if (c == 125) {
                        h.endObject();
                        st = (State)((Object)ss.pop());
                        c = rd.read();
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case STRING: {
                    c = rd.read();
                    if (c < 0) {
                        throw new JSONParseException("invalid EOF");
                    }
                    if (c == quot) {
                        h.setString(b.toString());
                        b = new StringBuilder();
                        st = (State)((Object)ss.pop());
                        quot = -1;
                        break;
                    }
                    if (c == 92) {
                        st = State.STRING_ESCAPE;
                        break;
                    }
                    b.append((char)c);
                    break;
                }
                case STRING_ESCAPE: {
                    c = JSONParser.noteof(rd);
                    switch (c) {
                        case 34: {
                            b.append('\"');
                            break;
                        }
                        case 92: {
                            b.append('\\');
                            break;
                        }
                        case 47: {
                            b.append('/');
                            break;
                        }
                        case 98: {
                            b.append('\b');
                            break;
                        }
                        case 102: {
                            b.append('\f');
                            break;
                        }
                        case 110: {
                            b.append('\n');
                            break;
                        }
                        case 114: {
                            b.append('\r');
                            break;
                        }
                        case 116: {
                            b.append('\t');
                            break;
                        }
                        case 117: {
                            c = JSONParser.readhex(rd);
                            c = c << 4 | JSONParser.readhex(rd);
                            c = c << 4 | JSONParser.readhex(rd);
                            c = c << 4 | JSONParser.readhex(rd);
                            b.append((char)c);
                            break;
                        }
                        default: {
                            throw new JSONParseException("invalid character" + (char)c);
                        }
                    }
                    st = State.STRING;
                    break;
                }
                case LITERAL: {
                    c = rd.read();
                    if (Character.isLowerCase(c)) {
                        b.append((char)c);
                        break;
                    }
                    String s = b.toString();
                    if (s.equals("true")) {
                        h.setTrue();
                    } else if (s.equals("false")) {
                        h.setFalse();
                    } else if (s.equals("null")) {
                        h.setNull();
                    } else {
                        throw new JSONParseException("invalid character" + (char)c);
                    }
                    b = new StringBuilder();
                    st = (State)((Object)ss.pop());
                    break;
                }
                case NUMBER: {
                    c = rd.read();
                    if (c < 0 || JSONParser.isws(c) || JSONParser.isdelimiter(c)) {
                        h.setInteger(JSONParser.getinteger(sign, b.toString()));
                        b = new StringBuilder();
                        st = (State)((Object)ss.pop());
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        b.append((char)c);
                        break;
                    }
                    if (c == 46) {
                        st = State.NUMBER_FRAC;
                        break;
                    }
                    if (c == 101 || c == 69) {
                        c = JSONParser.noteof(rd);
                        if (c == 43) {
                            singe = 1;
                        } else if (c == 45) {
                            singe = -1;
                        } else if (c >= 48 && c <= 57) {
                            singe = 1;
                            b3.append((char)c);
                        } else {
                            throw new JSONParseException("invalid charcter");
                        }
                        st = State.NUMBER_EXP;
                        break;
                    }
                    throw new JSONParseException("invalid charcter");
                }
                case NUMBER_FRAC: {
                    c = rd.read();
                    if (c < 0 || JSONParser.isws(c) || JSONParser.isdelimiter(c)) {
                        h.setFraction(JSONParser.getfraction(sign, b.toString(), b2.toString()));
                        b = new StringBuilder();
                        b2 = new StringBuilder();
                        st = (State)((Object)ss.pop());
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        b2.append((char)c);
                        break;
                    }
                    if (c == 101 || c == 69) {
                        c = JSONParser.noteof(rd);
                        if (c == 43) {
                            singe = 1;
                        } else if (c == 45) {
                            singe = -1;
                        } else if (c >= 48 && c <= 57) {
                            singe = 1;
                            b3.append((char)c);
                        } else {
                            throw new JSONParseException("invalid charcter");
                        }
                        st = State.NUMBER_EXP;
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                case NUMBER_EXP: {
                    c = rd.read();
                    if (c < 0 || JSONParser.isws(c) || JSONParser.isdelimiter(c)) {
                        h.setFraction(JSONParser.getfraction(sign, b.toString(), b2.toString(), singe, b3.toString()));
                        b = new StringBuilder();
                        b2 = new StringBuilder();
                        b3 = new StringBuilder();
                        st = (State)((Object)ss.pop());
                        break;
                    }
                    if (c >= 48 && c <= 57) {
                        b3.append((char)c);
                        break;
                    }
                    throw new JSONParseException("invalid character" + (char)c);
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }
        return h.eof();
    }

    public static Object parse(final Reader reader, JSONParseHandler handler) throws JSONParseException, IOException {
        Readable rd = new Readable(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }
        };
        return JSONParser.parse(rd, handler);
    }

    public static Object parse(final CharSequence seq, JSONParseHandler handler) throws JSONParseException {
        Readable rd = new Readable(){
            int p = 0;

            @Override
            public int read() {
                return this.p < seq.length() ? (int)seq.charAt(this.p++) : -1;
            }
        };
        try {
            return JSONParser.parse(rd, handler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object parseExact(Reader reader) throws JSONParseException, IOException {
        return JSONParser.parse(reader, (JSONParseHandler)new JavaHandler1(null, null));
    }

    public static Object parseExact(CharSequence reader) throws JSONParseException {
        return JSONParser.parse(reader, (JSONParseHandler)new JavaHandler1(null, null));
    }

    public static Object parseInexact(Reader reader) throws JSONParseException, IOException {
        return JSONParser.parse(reader, (JSONParseHandler)new JavaHandler2());
    }

    public static Object parseInexact(CharSequence reader) throws JSONParseException {
        return JSONParser.parse(reader, (JSONParseHandler)new JavaHandler2());
    }

    private static class JavaHandler1
    implements JSONParseHandler {
        Stack<Object> stack = new Stack();

        private JavaHandler1() {
        }

        @Override
        public void begin() {
        }

        @Override
        public Object eof() {
            return this.stack.pop();
        }

        @Override
        public void beginArray() {
            this.stack.push(new ArrayList());
        }

        @Override
        public void beginObject() {
            this.stack.push(new HashMap());
        }

        @Override
        public void nextArray() {
            Object o = this.stack.pop();
            List l = (List)this.stack.peek();
            l.add(o);
        }

        @Override
        public void endArray() {
            this.nextArray();
        }

        @Override
        public void nextValue() {
        }

        @Override
        public void nextObject() {
            Object v = this.stack.pop();
            Object k = this.stack.pop();
            Map l = (Map)this.stack.peek();
            l.put(k, v);
        }

        @Override
        public void endObject() {
            this.nextObject();
        }

        @Override
        public void setString(String s) {
            this.stack.push(s);
        }

        @Override
        public void setTrue() {
            this.stack.push(Boolean.TRUE);
        }

        @Override
        public void setFalse() {
            this.stack.push(Boolean.FALSE);
        }

        @Override
        public void setNull() {
            this.stack.push(null);
        }

        @Override
        public void setInteger(BigInteger x) {
            this.stack.push(x);
        }

        @Override
        public void setFraction(BigDecimal x) {
            this.stack.push(x);
        }

        @Override
        public void emptyArray() {
        }

        @Override
        public void emptyObject() {
        }

        /* synthetic */ JavaHandler1(JavaHandler1 javaHandler1, JavaHandler1 javaHandler12) {
            this();
        }
    }

    private static class JavaHandler2
    extends JavaHandler1 {
        private JavaHandler2() {
        }

        @Override
        public void setInteger(BigInteger x) {
            this.stack.push(x.longValue());
        }

        @Override
        public void setFraction(BigDecimal x) {
            this.stack.push(x.doubleValue());
        }
    }

    private static interface Readable {
        public int read() throws IOException;
    }

    private static enum State {
        INIT,
        ARRAY,
        ARRAY_SEP,
        OBJECT,
        OBJECT_KEYSEP,
        OBJECT_VALUE,
        OBJECT_SEP,
        STRING,
        STRING_ESCAPE,
        LITERAL,
        NUMBER,
        NUMBER_FRAC,
        NUMBER_EXP;

    }
}

