/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.snmp;

import java.util.ArrayList;
import net.morilib.net.snmp.ASN1Exception;
import net.morilib.net.snmp.ASN1Tag;
import net.morilib.net.snmp.ObjectIdentifier;

public class ASN1TagOID
extends ASN1Tag {
    ASN1TagOID() {
        super(0, false, (byte)6);
    }

    @Override
    protected Object analyse(byte[] bts) throws ASN1Exception {
        ArrayList<Integer> l = new ArrayList<Integer>();
        int x = 0;
        int cnt = 0;
        if (bts == null) {
            throw new NullPointerException();
        }
        if (bts.length == 0) {
            throw new ASN1Exception();
        }
        l.add(bts[0] / 40);
        l.add(bts[0] % 40);
        int i = 1;
        while (i < bts.length) {
            if (cnt == 0) {
                if ((bts[i] & 0x80) == 0) {
                    l.add(bts[i] & 0x7F);
                } else {
                    cnt = 1;
                    x = bts[i] & 0x7F;
                }
            } else {
                if (cnt > 3) {
                    throw new ASN1Exception();
                }
                x = x << 7 | bts[i] & 0x7F;
                if ((bts[i] & 0x80) == 0) {
                    l.add(x);
                    cnt = 0;
                    x = 0;
                } else {
                    ++cnt;
                }
            }
            ++i;
        }
        if (cnt != 0) {
            throw new ASN1Exception();
        }
        int[] r = new int[l.size()];
        i = 0;
        while (i < l.size()) {
            r[i] = (Integer)l.get(i);
            ++i;
        }
        try {
            return new ObjectIdentifier(r, false);
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception("illegal OID");
        }
    }
}

