/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.net.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import net.morilib.net.misc.TFTPErrorPacketException;

public final class TFTP {
    public static final String NETASCII_MODE = "netascii";
    public static final String OCTET_MODE = "octet";
    public static final String MAIL_MODE = "mail";
    public static final int DEFAULT_PORT = 69;
    private static final short RRQ = 1;
    private static final short WRQ = 2;
    private static final short DATA = 3;
    private static final short ACK = 4;
    private static final short ERR = 5;
    private static final int DEFAULT_TIMEOUT = 2000;

    private TFTP() {
    }

    static void putstr(DataOutputStream dos, String str) throws IOException {
        dos.write(str.getBytes());
        dos.writeByte(0);
    }

    static byte[] newRWRQ(short rw, String filename, String mode) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (rw != 1 && rw != 2) {
                throw new IllegalArgumentException();
            }
            if (filename == null || mode == null) {
                throw new NullPointerException();
            }
            if (filename.equals("") || mode.equals("")) {
                throw new IllegalArgumentException();
            }
            dos.writeShort(rw);
            TFTP.putstr(dos, filename);
            TFTP.putstr(dos, mode);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void throwErrorPacket(DataInputStream dis) throws IOException {
        byte[] b = new byte[512];
        int ec = dis.readUnsignedShort();
        int l = dis.read(b) - 1;
        throw new TFTPErrorPacketException(new String(b, 0, l), ec);
    }

    static int checkAck(DatagramSocket sok, byte[] b, int c) throws IOException {
        DatagramPacket rpk = new DatagramPacket(b, b.length);
        sok.receive(rpk);
        ByteArrayInputStream bis = new ByteArrayInputStream(b, 0, rpk.getLength());
        DataInputStream dis = new DataInputStream(bis);
        short cd = dis.readShort();
        if (cd == 5) {
            TFTP.throwErrorPacket(dis);
        } else {
            if (cd != 4) {
                throw new ProtocolException("illegal state");
            }
            if (dis.readUnsignedShort() != c) {
                throw new ProtocolException("block number");
            }
        }
        return rpk.getPort();
    }

    static void putdata(DatagramSocket sok, InetAddress addr, int port, InputStream ins) throws IOException {
        int l;
        byte[] b = new byte[516];
        byte[] s = null;
        int c = 0;
        while ((l = ins.read(b, 4, 512)) >= 0) {
            if (l == 0 || l > 512) continue;
            if (l < 512) {
                s = new byte[l + 4];
                ++c;
                System.arraycopy(b, 0, s, 0, s.length);
            } else if (l == 512) {
                s = b;
                ++c;
            }
            s[0] = 0;
            s[1] = 3;
            s[2] = (byte)(c >> 8);
            s[3] = (byte)(c & 0xFF);
            DatagramPacket spk = new DatagramPacket(s, s.length, addr, port);
            sok.send(spk);
            TFTP.checkAck(sok, b, c);
        }
    }

    static long getdata(DatagramSocket sok, InetAddress addr, OutputStream ous) throws IOException {
        byte[] b = new byte[516];
        byte[] s = new byte[4];
        long l = 0L;
        try {
            int c = 1;
            while (true) {
                DatagramPacket rpk = new DatagramPacket(b, b.length);
                sok.receive(rpk);
                ByteArrayInputStream bis = new ByteArrayInputStream(b, 0, rpk.getLength());
                DataInputStream dis = new DataInputStream(bis);
                short cd = dis.readShort();
                if (cd == 5) {
                    TFTP.throwErrorPacket(dis);
                } else {
                    if (cd != 3) {
                        throw new ProtocolException("illegal state");
                    }
                    if (dis.readUnsignedShort() != c) {
                        throw new ProtocolException("block number");
                    }
                }
                ous.write(b, 4, rpk.getLength());
                l += (long)(rpk.getLength() - 4);
                int port = rpk.getPort();
                s[0] = 0;
                s[1] = 4;
                s[2] = (byte)(c >> 8);
                s[3] = (byte)(c & 0xFF);
                DatagramPacket spk = new DatagramPacket(s, s.length, addr, port);
                sok.send(spk);
                ++c;
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return l;
        }
    }

    public static void put(InetAddress addr, int port, String filename, String mode, InputStream ins) throws IOException {
        DatagramSocket sok = new DatagramSocket();
        sok.setSoTimeout(2000);
        byte[] b = TFTP.newRWRQ((short)2, filename, mode);
        DatagramPacket spk = new DatagramPacket(b, b.length, addr, port);
        sok.send(spk);
        TFTP.putdata(sok, addr, TFTP.checkAck(sok, b, 0), ins);
    }

    public static void put(String host, int port, String filename, String mode, InputStream ins) throws IOException {
        TFTP.put(InetAddress.getByName(host), port, filename, mode, ins);
    }

    public static void put(InetAddress addr, String filename, String mode, InputStream ins) throws IOException {
        TFTP.put(addr, 69, filename, mode, ins);
    }

    public static void put(String host, String filename, String mode, InputStream ins) throws IOException {
        TFTP.put(InetAddress.getByName(host), 69, filename, mode, ins);
    }

    public static long get(InetAddress addr, int port, String filename, String mode, OutputStream ous) throws IOException {
        DatagramSocket sok = new DatagramSocket();
        sok.setSoTimeout(2000);
        byte[] b = TFTP.newRWRQ((short)1, filename, mode);
        DatagramPacket spk = new DatagramPacket(b, b.length, addr, port);
        sok.send(spk);
        return TFTP.getdata(sok, addr, ous);
    }

    public static void get(String host, int port, String filename, String mode, OutputStream ous) throws IOException {
        TFTP.get(InetAddress.getByName(host), port, filename, mode, ous);
    }

    public static void get(InetAddress addr, String filename, String mode, OutputStream ous) throws IOException {
        TFTP.get(addr, 69, filename, mode, ous);
    }

    public static void get(String host, String filename, String mode, OutputStream ous) throws IOException {
        TFTP.get(InetAddress.getByName(host), 69, filename, mode, ous);
    }
}

