/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.stat.dist.continuous;

import net.morilib.lang.transform.DoubleTransform;
import net.morilib.math.special.Gamma2;
import net.morilib.math.stat.dist.AbstractContinuousDistribution;

public class GammaDistribution
extends AbstractContinuousDistribution {
    double k;
    double theta;
    private final DoubleTransform lningamma;
    private final double lngammak;

    public GammaDistribution(double k, double theta) {
        if (k <= 0.0 || theta <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.k = k;
        this.theta = theta;
        this.lngammak = Gamma2.lnGamma(k);
        this.lningamma = Gamma2.lnIncompleteGammaLowerFunction(k);
    }

    public static GammaDistribution chiSquared(int k) {
        if (k <= 0) {
            throw new IllegalArgumentException();
        }
        return new GammaDistribution((double)k / 2.0, 2.0);
    }

    public static GammaDistribution erlang(int k, double lambda) {
        if (k <= 0) {
            throw new IllegalArgumentException();
        }
        return new GammaDistribution(k, 1.0 / lambda);
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    @Override
    public double f(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x == 0.0) {
            return this.k == 1.0 ? 1.0 / this.theta : 0.0;
        }
        double r = (this.k - 1.0) * Math.log(x) - x / this.theta;
        return Math.exp(r -= this.k * Math.log(this.theta) + this.lngammak);
    }

    @Override
    public double cdf(double x) {
        return x > 0.0 ? Math.exp(this.lningamma.f(x / this.theta) - this.lngammak) : 0.0;
    }

    @Override
    public boolean isInSupport(double n) {
        return n >= 0.0;
    }

    @Override
    public double supportSupremum() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double supportInfimum() {
        return 0.0;
    }

    @Override
    public double expectedValue() {
        return this.k * this.theta;
    }

    @Override
    public double variance() {
        return this.k * this.theta * this.theta;
    }

    @Override
    public double mode() {
        return this.k < 1.0 ? 0.0 : (this.k - 1.0) * this.theta;
    }

    @Override
    public double skewness() {
        return 2.0 / Math.sqrt(this.k);
    }

    @Override
    public double kurtosis() {
        return 6.0 / this.k;
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + (int)Double.doubleToLongBits(this.k));
        r = 37 * (r + (int)Double.doubleToLongBits(this.theta));
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof GammaDistribution) {
            GammaDistribution n = (GammaDistribution)o;
            return this.k == n.k && this.theta == n.theta;
        }
        return false;
    }
}

