/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.functions;

import net.morilib.lang.algebra.FieldElement;
import net.morilib.math.functions.Polynomial1Coefficients;
import net.morilib.math.functions.Polynomial1s;

public class RationalFunction1Coefficients<C extends FieldElement<C>>
implements FieldElement<RationalFunction1Coefficients<C>> {
    private Polynomial1Coefficients<C> numerator;
    private Polynomial1Coefficients<C> denominator;

    private RationalFunction1Coefficients(Polynomial1Coefficients<C> n, Polynomial1Coefficients<C> d) {
        this.numerator = n;
        this.denominator = d;
    }

    public static <C extends FieldElement<C>> RationalFunction1Coefficients<C> valueOf(Polynomial1Coefficients<C> n, Polynomial1Coefficients<C> d) {
        if (d.isZero()) {
            throw new ArithmeticException();
        }
        Polynomial1Coefficients<C> gcd = Polynomial1s.gcd(n, d);
        return new RationalFunction1Coefficients<C>(n.divide(gcd), d.divide(gcd));
    }

    @Override
    public boolean isUnit() {
        return this.numerator.isUnit() && this.denominator.isUnit();
    }

    @Override
    public boolean isZero() {
        return this.numerator.isZero();
    }

    @Override
    public RationalFunction1Coefficients<C> negate() {
        return new RationalFunction1Coefficients<C>(this.numerator.negate(), this.denominator);
    }

    @Override
    public RationalFunction1Coefficients<C> subtract(RationalFunction1Coefficients<C> x) {
        Polynomial1Coefficients<Polynomial1Coefficients<Polynomial1Coefficients<C>>> x1 = this.numerator.multiply(x.denominator);
        Polynomial1Coefficients<Polynomial1Coefficients<C>> x2 = x.numerator.multiply(this.denominator);
        return RationalFunction1Coefficients.valueOf(x1.subtract(x2), this.denominator.multiply(this.denominator));
    }

    @Override
    public RationalFunction1Coefficients<C> add(RationalFunction1Coefficients<C> x) {
        Polynomial1Coefficients<Polynomial1Coefficients<Polynomial1Coefficients<C>>> x1 = this.numerator.multiply(x.denominator);
        Polynomial1Coefficients<Polynomial1Coefficients<C>> x2 = x.numerator.multiply(this.denominator);
        return RationalFunction1Coefficients.valueOf(x1.add(x2), this.denominator.multiply(this.denominator));
    }

    @Override
    public RationalFunction1Coefficients<C> multiply(int n) {
        return new RationalFunction1Coefficients<C>(this.numerator.multiply(n), this.denominator);
    }

    @Override
    public RationalFunction1Coefficients<C> multiply(RationalFunction1Coefficients<C> x) {
        return RationalFunction1Coefficients.valueOf(this.numerator.multiply(x.numerator), this.denominator.multiply(this.denominator));
    }

    @Override
    public RationalFunction1Coefficients<C> power(int n) {
        return new RationalFunction1Coefficients<C>(this.numerator.power(n), this.denominator.power(n));
    }

    @Override
    public RationalFunction1Coefficients<C> invert() {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        return new RationalFunction1Coefficients<C>(this.denominator, this.numerator);
    }

    @Override
    public RationalFunction1Coefficients<C> divide(RationalFunction1Coefficients<C> x) {
        return RationalFunction1Coefficients.valueOf(this.numerator.multiply(x.denominator), this.denominator.multiply(this.numerator));
    }

    public Polynomial1Coefficients<C> getNumerator() {
        return this.numerator;
    }

    public Polynomial1Coefficients<C> getDenominator() {
        return this.denominator;
    }

    public int hashCode() {
        int r = 17;
        if (this.isZero()) {
            return 72;
        }
        r = 37 * (r + this.numerator.hashCode());
        r = 37 * (r + this.denominator.hashCode());
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RationalFunction1Coefficients) {
            RationalFunction1Coefficients x = (RationalFunction1Coefficients)obj;
            return this.isZero() && x.isZero() || this.numerator.equals(x.numerator) && this.denominator.equals(x.denominator);
        }
        return false;
    }

    public String toString(String var) {
        if (this.isZero()) {
            return "0";
        }
        if (this.denominator.isUnit()) {
            return this.numerator.toString(var);
        }
        return "(" + this.numerator.toString(var) + ") /" + "(" + this.denominator.toString(var) + ")";
    }

    public String toString() {
        return this.toString("x");
    }
}

