/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sssp;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Symbol;

public abstract class TagTransformer {
    public static final TagTransformer STRING = new TagTransformer(){

        @Override
        public Datum transform(String s) {
            return new LispString(s);
        }
    };
    public static final TagTransformer INTEGER = new TagTransformer(){

        @Override
        public Datum transform(String s) {
            try {
                return LispInteger.valueOf(new BigInteger(s));
            }
            catch (NumberFormatException e) {
                return LispBoolean.FALSE;
            }
        }
    };
    public static final TagTransformer BOOLEAN = new TagTransformer(){

        @Override
        public Datum transform(String s) {
            return LispBoolean.getInstance(s.equalsIgnoreCase("true") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("yes"));
        }
    };
    public static final TagTransformer NUMBER = new TagTransformer(){

        @Override
        public Datum transform(String s) {
            LispNumber d = LispNumber.parse(s, 10);
            return d == null ? LispBoolean.FALSE : d;
        }
    };
    public static final TagTransformer SYMBOL = new TagTransformer(){

        @Override
        public Datum transform(String s) {
            return Symbol.getSymbol(s);
        }
    };
    private static final Map<Datum, TagTransformer> TAGS = new HashMap<Datum, TagTransformer>();

    static {
        TAGS.put(Symbol.getSymbol("string"), STRING);
        TAGS.put(Symbol.getSymbol("symbol"), SYMBOL);
        TAGS.put(Symbol.getSymbol("integer"), INTEGER);
        TAGS.put(Symbol.getSymbol("boolean"), BOOLEAN);
        TAGS.put(Symbol.getSymbol("number"), NUMBER);
    }

    protected TagTransformer() {
    }

    public static TagTransformer getInstance(Datum s) {
        return TAGS.get(s);
    }

    public abstract Datum transform(String var1);
}

