/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.keypair;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignedObject;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.security.keypair.LispPublicKey;
import net.morilib.lisp.security.keypair.LispSignature;
import net.morilib.lisp.security.keypair.LispSignedDatum;
import net.morilib.lisp.subr.SubrUtils;

public class VerifySignedDatum
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        String al = LispSignature.nextAlgorithm(itr, env, mesg, body);
        try {
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(d2 instanceof LispPublicKey)) {
                throw mesg.getError("err.keypair.require.key.public", d2);
            }
            if (d1 instanceof LispSignedDatum) {
                Signature sg = Signature.getInstance(al);
                SignedObject sd = ((LispSignedDatum)d1).datum;
                return LispBoolean.getInstance(sd.verify(((LispPublicKey)d2).key, sg));
            }
            throw mesg.getError("err.keypair.require.signeddatum", d1);
        }
        catch (NoSuchAlgorithmException e) {
            throw mesg.getError("err.digest.algorithm.notfound", al);
        }
        catch (InvalidKeyException e) {
            throw mesg.getError("err.keypair.key.invalid", d2);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

