/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.security.keypair;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.security.keypair.LispPrivateKey;
import net.morilib.lisp.security.keypair.LispSignature;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.IOs;

public class SignFile
extends Subr {
    private static final int BUF_SIZE = 2048;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        LispSignature lispSignature;
        BufferedInputStream ins = null;
        Datum c2a = LispString.EMPTY;
        String a1 = "";
        try {
            byte[] buf = new byte[2048];
            ConsIterator itr = new ConsIterator(body);
            File fn = LispFiles.nextFile(itr, env, mesg, body);
            c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            a1 = SubrUtils.nextSymbolName((Iterator<Datum>)itr, null, mesg);
            a1 = a1 != null ? String.valueOf(a1.toUpperCase()) + "with" + SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body).toUpperCase() : LispSignature.defaultAlgorithm(env);
            if (!(c2a instanceof LispPrivateKey)) {
                throw mesg.getError("err.keypair.require.key.private", c2a);
            }
            Signature sg = Signature.getInstance(a1);
            ins = new BufferedInputStream(new FileInputStream(fn));
            sg.initSign(((LispPrivateKey)c2a).key);
            while (true) {
                int sz;
                if ((sz = ((InputStream)ins).read(buf)) < 0) {
                    lispSignature = new LispSignature(sg.sign());
                    break;
                }
                sg.update(buf, 0, sz);
            }
        }
        catch (IOException e) {
            try {
                throw mesg.getError("err.io");
                catch (NoSuchAlgorithmException e2) {
                    throw mesg.getError("err.digest.algorithm.notfound", a1);
                }
                catch (InvalidKeyException e3) {
                    throw mesg.getError("err.keypair.key.invalid", c2a);
                }
                catch (SignatureException e4) {
                    throw new RuntimeException(e4);
                }
            }
            catch (Throwable throwable) {
                IOs.close(ins);
                throw throwable;
            }
        }
        IOs.close(ins);
        return lispSignature;
    }
}

