/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;

public class LookaheadInputTranscoder
implements InputTranscoder {
    private InputTranscoder tr;
    private int lookahead = -72;

    public LookaheadInputTranscoder(InputTranscoder tr) {
        this.tr = tr;
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }

    @Override
    public int read() throws IOException {
        if (this.lookahead == -72) {
            int r = this.tr.read();
            this.lookahead = this.tr.read();
            return r;
        }
        if (this.lookahead >= 0) {
            int r = this.lookahead;
            this.lookahead = this.tr.read();
            return r;
        }
        return this.lookahead;
    }

    @Override
    public int read(int[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(int[] b, int off, int len) throws IOException {
        if (this.lookahead == -72) {
            int r = this.tr.read(b, off, len);
            if (r > 0) {
                this.lookahead = this.tr.read();
                return r;
            }
            this.lookahead = -1;
            return -1;
        }
        if (this.lookahead < 0) {
            return -1;
        }
        int r = this.tr.read(b, off + 1, len - 1);
        if (r >= 0) {
            b[off] = this.lookahead;
            this.lookahead = this.tr.read();
            return r + 1;
        }
        if (r == 0) {
            return 0;
        }
        b[off] = this.lookahead;
        this.lookahead = r;
        return 1;
    }

    public int lookahead() throws IOException {
        if (this.lookahead == -72) {
            this.lookahead = this.tr.read();
        }
        return this.lookahead;
    }
}

