/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import java.io.OutputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.r6rs.io.ILispBinaryOutputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;

public class LispOutputStreamPort
extends Datum2
implements ILispBinaryOutputPort {
    private OutputStream ous;
    private LispBufferMode bm;

    public LispOutputStreamPort(OutputStream ous, LispBufferMode bm) {
        this.ous = bm.getOutputStream(ous);
        this.bm = bm;
    }

    @Override
    public void close() throws IOException {
        this.ous.close();
    }

    @Override
    public void putByte(int b) throws IOException {
        this.ous.write(b);
    }

    @Override
    public void putBytes(byte[] src) throws IOException {
        this.ous.write(src);
    }

    @Override
    public void putBytes(byte[] src, int start) throws IOException {
        this.ous.write(src, start, src.length - start);
    }

    @Override
    public void putBytes(byte[] src, int start, int end) throws IOException {
        this.ous.write(src, start, end - start);
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.ous;
    }

    @Override
    public boolean hasPortPosition() {
        return false;
    }

    @Override
    public Datum getPortPosition() {
        throw new LispNotSupportedException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return false;
    }

    @Override
    public void setPortPosition(Datum pos) {
        throw new LispNotSupportedException();
    }

    @Override
    public void flush() throws IOException {
        this.ous.flush();
    }

    @Override
    public LispBufferMode getBufferMode() {
        return this.bm;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<binary-output-port>");
    }
}

