/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.r6rs.io.ILispBinaryOutputPort;
import net.morilib.lisp.r6rs.io.InvalidPositionException;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.util.primitive.ByteArrayVector;
import net.morilib.util.primitive.ByteVector;

public class LispByteArrayBinaryOutputPort
extends Datum2
implements ILispBinaryOutputPort {
    private ByteVector buf;
    private int ptr;

    public LispByteArrayBinaryOutputPort() {
        this.buf = new ByteArrayVector();
        this.ptr = 0;
    }

    public LispByteArrayBinaryOutputPort(byte[] bytes) {
        this.buf = new ByteArrayVector(bytes);
        this.ptr = 0;
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public boolean hasPortPosition() {
        return true;
    }

    @Override
    public Datum getPortPosition() {
        return LispInteger.valueOf(this.ptr);
    }

    @Override
    public boolean hasSetPortPosition() {
        return true;
    }

    @Override
    public void setPortPosition(Datum pos) throws InvalidPositionException {
        if (!(pos instanceof LispSmallInt)) {
            throw new InvalidPositionException();
        }
        int p = pos.getInt();
        if (p < 0 || p > this.buf.size()) {
            throw new InvalidPositionException();
        }
        this.ptr = p;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public LispBufferMode getBufferMode() {
        return LispBufferMode.NONE;
    }

    @Override
    public void putByte(int b) throws IOException {
        this.buf.add(this.ptr++, b);
    }

    @Override
    public void putBytes(byte[] src) throws IOException {
        this.buf.addAllByte(this.ptr, src);
        this.ptr += src.length;
    }

    @Override
    public void putBytes(byte[] src, int start) throws IOException {
        this.putBytes(src, start, src.length);
    }

    @Override
    public void putBytes(byte[] src, int start, int end) throws IOException {
        byte[] b = new byte[end - start];
        System.arraycopy(src, start, b, 0, b.length);
        this.buf.addAllByte(this.ptr, b);
        this.ptr += b.length;
    }

    @Override
    public OutputStream getOutputStream() {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        ous.write(this.buf.toByteArray(), 0, this.ptr);
        return ous;
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<bytevector-binary-output-port>");
    }
}

