/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.dist;

import net.morilib.lisp.math.stat.dist.AbstractLispDistribution;
import net.morilib.math.stat.dist.ContinuousDistribution;
import net.morilib.math.stat.dist.continuous.GammaDistribution;

public class LispGammaDistribution
extends AbstractLispDistribution {
    GammaDistribution dist;

    public LispGammaDistribution(GammaDistribution dist) {
        this.dist = dist;
    }

    @Override
    public ContinuousDistribution getDistribution() {
        return this.dist;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        if (Math.IEEEremainder(this.dist.getK(), 0.5) == 0.0 && this.dist.getTheta() == 2.0) {
            buf.append("#<chi^2(k=").append((int)(this.dist.getK() * 2.0));
        } else if (Math.IEEEremainder(this.dist.getK(), 1.0) == 0.0) {
            buf.append("#<Erlang(k=").append((int)this.dist.getK());
            buf.append(", lambda=").append(1.0 / this.dist.getTheta());
        } else {
            buf.append("#<gamma(k=").append(this.dist.getK());
            buf.append(", theta=").append(this.dist.getTheta());
        }
        buf.append(")>");
    }
}

