/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.matrix.ILispNumberVector;
import net.morilib.lisp.math.matrix.LispMatrixException;

public class LispNumberVector
extends Datum2
implements ILispNumberVector {
    private LispNumber[] array;

    public LispNumberVector(int size) {
        this(size, (LispNumber)LispInteger.ZERO);
    }

    public LispNumberVector(int size, LispNumber fill) {
        this.array = new LispNumber[size];
        Arrays.fill(this.array, fill);
    }

    LispNumberVector(LispNumber ... nums) {
        this.array = nums;
    }

    public static LispNumberVector newInstance(LispNumber ... nums) {
        LispNumber[] c = new LispNumber[nums.length];
        System.arraycopy(nums, 0, c, 0, nums.length);
        return new LispNumberVector(c);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public LispNumber get(int index) {
        return this.array[index];
    }

    @Override
    public void set(int index, LispNumber x) {
        this.array[index] = x;
    }

    @Override
    public ILispNumberVector mul(LispNumber x) {
        LispNumberVector r = new LispNumberVector(this.array.length);
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i].mul(x);
            ++i;
        }
        return r;
    }

    @Override
    public ILispNumberVector add(ILispNumberVector v) {
        LispNumberVector r = new LispNumberVector(this.array.length);
        if (this.array.length != v.size()) {
            throw new LispMatrixException();
        }
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i].add(v.get(i));
            ++i;
        }
        return r;
    }

    @Override
    public ILispNumberVector sub(ILispNumberVector v) {
        LispNumberVector r = new LispNumberVector(this.array.length);
        if (this.array.length != v.size()) {
            throw new LispMatrixException();
        }
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i].sub(v.get(i));
            ++i;
        }
        return r;
    }

    @Override
    public ILispNumberVector uminus() {
        LispNumberVector r = new LispNumberVector(this.array.length);
        int i = 0;
        while (i < this.array.length) {
            r.array[i] = this.array[i].uminus();
            ++i;
        }
        return r;
    }

    @Override
    public Iterator<LispNumber> iterator() {
        return new Iterator<LispNumber>(){
            private int p = 0;

            @Override
            public boolean hasNext() {
                return this.p < LispNumberVector.this.array.length;
            }

            @Override
            public LispNumber next() {
                if (this.p >= LispNumberVector.this.array.length) {
                    throw new NoSuchElementException();
                }
                return LispNumberVector.this.array[this.p++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public LispNumber innerProduct(ILispNumberVector b) throws LispMatrixException {
        if (b.size() != this.size()) {
            throw new LispMatrixException();
        }
        LispNumber x = LispInteger.ZERO;
        int i = 0;
        while (i < this.size()) {
            x = ((LispNumber)x).add(this.get(i).mul(b.get(i)));
            ++i;
        }
        return x;
    }

    @Override
    public LispNumber normSquare() {
        LispNumber x = LispInteger.ZERO;
        int i = 0;
        while (i < this.size()) {
            x = ((LispNumber)x).add(this.get(i).mul(this.get(i)));
            ++i;
        }
        return x;
    }

    public int hashCode() {
        int r = 17;
        int i = 0;
        while (i < this.size()) {
            r = 37 * (r + this.get(i).hashCode());
            ++i;
        }
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof ILispNumberVector) {
            ILispNumberVector y = (ILispNumberVector)o;
            if (this.size() == y.size()) {
                int i = 0;
                while (i < this.size()) {
                    if (!this.get(i).isEqualTo(y.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isEqualTo(ILispNumberVector y) {
        if (this.size() == y.size()) {
            int i = 0;
            while (i < this.size()) {
                if (!this.get(i).isEqualTo(y.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("(number-vector");
        for (LispNumber x : this) {
            buf.append(" ").append(LispUtils.print(x));
        }
        buf.append(")");
    }
}

