/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import java.util.NoSuchElementException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.iterator.ILispIterator;

public class LispCompoundIterator
extends Datum2
implements ILispIterator {
    private ILispIterator[] iterators;
    private int ptr;

    LispCompoundIterator(boolean dummy, ILispIterator[] iterators) {
        this.iterators = iterators;
    }

    public LispCompoundIterator(ILispIterator ... iterators) {
        this(false, LispCompoundIterator._c(iterators));
    }

    private static ILispIterator[] _c(ILispIterator[] iterators) {
        ILispIterator[] r = new ILispIterator[iterators.length];
        System.arraycopy(iterators, 0, r, 0, r.length);
        return r;
    }

    @Override
    public boolean isTerminated() {
        return this.ptr >= this.iterators.length;
    }

    @Override
    public ILispIterator next() {
        if (this.isTerminated()) {
            throw new NoSuchElementException();
        }
        this.iterators[this.ptr] = this.iterators[this.ptr].next();
        if (this.iterators[this.ptr].isTerminated()) {
            ++this.ptr;
        }
        return this;
    }

    @Override
    public Datum getCurrentDatum() {
        if (this.isTerminated()) {
            throw new NoSuchElementException();
        }
        return this.iterators[this.ptr].getCurrentDatum();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<compound-iterator>");
    }
}

