/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispLineBuffer;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class LispListBuffer
extends LispLineBuffer {
    private ConsListBuilder buf = new ConsListBuilder();

    @Override
    public void putLine(Datum s) {
        this.buf.append(s);
    }

    @Override
    public void close() {
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<list-buffer>");
    }

    public static class GetListFromBuffer
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispListBuffer) {
                return ((LispListBuffer)c1a).buf.get();
            }
            throw mesg.getError("err.file.require.listbuffer", c1a);
        }
    }

    public static class OpenListBuffer
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            SubrUtils.checkTerminated(itr, body, mesg);
            return new LispListBuffer();
        }
    }
}

