/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.exlib;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.format.DatumFormatArguments;
import net.morilib.lisp.format.FormatArguments;
import net.morilib.lisp.format.FormatArgumentsException;
import net.morilib.lisp.format.FormatParseException;
import net.morilib.lisp.format.LispFormat;
import net.morilib.lisp.format.LispFormatException;

public class LispFormatSubr
extends Subr {
    private Cons checkGetCdr(Cons c1, LispMessage mesg) {
        if (c1.getCdr() instanceof Cons) {
            return (Cons)c1.getCdr();
        }
        throw mesg.getError("err.parameter.insufficient", "format");
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        OutputPort outp = null;
        if (body instanceof Cons) {
            Cons c1 = (Cons)body;
            if (c1.getCar() instanceof OutputPort) {
                outp = (OutputPort)c1.getCar();
                c1 = this.checkGetCdr(c1, mesg);
            } else if (LispBoolean.TRUE.equals(c1.getCar())) {
                outp = OutputPort.getStandard(mesg);
                c1 = this.checkGetCdr(c1, mesg);
            } else if (LispBoolean.FALSE.equals(c1.getCar())) {
                outp = null;
                c1 = this.checkGetCdr(c1, mesg);
            }
            if (c1.getCar().isTypeString()) {
                try {
                    String fmt = c1.getCar().getString();
                    String formatted = LispFormat.getInstance().format(fmt, (FormatArguments)new DatumFormatArguments(c1.getCdr()));
                    LispString res = new LispString(formatted);
                    if (outp == null) {
                        return res;
                    }
                    outp.display(res);
                    return Undef.UNDEF;
                }
                catch (FormatArgumentsException e) {
                    throw mesg.getError("err.srfi28.arguments.insufficient");
                }
                catch (FormatParseException e) {
                    throw mesg.getError("err.srfi28.format.syntax");
                }
                catch (LispFormatException e) {
                    throw mesg.getError("err.srfi28.format");
                }
            }
        }
        throw mesg.getError("err.parameter.insufficient", "format");
    }
}

