/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.desktop;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class DesktopBrowse
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        URI s = SubrUtils.getURI(c1a, mesg);
        if (!Desktop.isDesktopSupported()) {
            return LispBoolean.FALSE;
        }
        Desktop dsk = Desktop.getDesktop();
        if (!dsk.isSupported(Desktop.Action.BROWSE)) {
            return LispBoolean.FALSE;
        }
        try {
            dsk.browse(s);
            return LispBoolean.TRUE;
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
    }
}

