/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Map;
import java.util.WeakHashMap;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;
import net.morilib.lisp.sos.LispType;

public final class Keyword
extends Atom {
    private static Map<String, Keyword> flyweight;
    private String name;

    private Keyword(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyword getKeyword(String name) {
        if (name == null) {
            throw new NullPointerException("Keyword");
        }
        Class<Keyword> clazz = Keyword.class;
        synchronized (Keyword.class) {
            Keyword res;
            if (flyweight == null) {
                flyweight = new WeakHashMap<String, Keyword>();
            }
            if ((res = flyweight.get(name)) == null) {
                res = new Keyword(name);
                flyweight.put(name, res);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return res;
        }
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.getName());
    }

    @Override
    public String print() {
        return ":" + this.getName();
    }

    @Override
    public String getResult() {
        return ":" + this.getName();
    }

    @Override
    public String toString() {
        return "Keyword:" + this.getName();
    }

    @Override
    public LispType getType() {
        return LispType.KEYWORD;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(":" + this.getName());
    }
}

