/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.ldap;

import net.morilib.ldap.AttributeFilter;
import net.morilib.ldap.AttributeType;

public class ExtensibleAttributeFilter
implements AttributeFilter {
    public static final boolean WITH_DN = true;
    public static final boolean WITHOUT_DN = false;
    private AttributeType key;
    private boolean dn;
    private String matchingRule;
    private String value;

    public ExtensibleAttributeFilter(AttributeType key, boolean dn, String matchingRule, String value) {
        if (key == null && matchingRule == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.dn = dn;
        this.matchingRule = matchingRule;
        this.value = value;
    }

    public ExtensibleAttributeFilter(String key, boolean dn, String matchingRule, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (key == null && matchingRule == null) {
            throw new NullPointerException();
        }
        this.key = new AttributeType(key);
        this.dn = dn;
        this.matchingRule = matchingRule;
        this.value = value;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.key != null) {
            b.append(this.key.toString());
        }
        b.append(this.dn ? "" : ":dn");
        if (this.matchingRule != null) {
            b.append(":").append(this.matchingRule);
        }
        b.append(":=").append(this.value);
        return b.toString();
    }
}

