/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.xml;

import java.io.IOException;
import java.io.Reader;
import net.morilib.util.xml.XMLDeclaration;
import net.morilib.util.xml.XMLDeclarationException;

public class XMLDeclarationParser {
    private static final int INIT = 0;
    private static final int INIT_1 = 1;
    private static final int INIT_2 = 2;
    private static final int INIT_X = 3;
    private static final int INIT_M = 4;
    private static final int INIT_L = 5;
    private static final int VERSION_0 = 101;
    private static final int VERSION_V = 102;
    private static final int VERSION_E = 103;
    private static final int VERSION_R = 104;
    private static final int VERSION_S = 105;
    private static final int VERSION_I = 106;
    private static final int VERSION_O = 107;
    private static final int VERSION_N = 108;
    private static final int ENC_OR_ST = 200;
    private static final int ENCODING_E = 401;
    private static final int ENCODING_N1 = 402;
    private static final int ENCODING_C = 403;
    private static final int ENCODING_O = 404;
    private static final int ENCODING_D = 405;
    private static final int ENCODING_I = 406;
    private static final int ENCODING_N2 = 407;
    private static final int ENCODING_G = 408;
    private static final int STANDALONE_0 = 501;
    private static final int STANDALONE_S = 502;
    private static final int STANDALONE_T = 503;
    private static final int STANDALONE_A1 = 504;
    private static final int STANDALONE_N1 = 505;
    private static final int STANDALONE_D = 506;
    private static final int STANDALONE_A2 = 507;
    private static final int STANDALONE_L = 508;
    private static final int STANDALONE_O = 509;
    private static final int STANDALONE_N2 = 510;
    private static final int STANDALONE_E = 511;
    private static final int END_0 = 901;
    private static final int END_1 = 902;

    private static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10;
    }

    private static int skipWhitespace(Reader rd, int bc) throws IOException, XMLDeclarationException {
        int c = bc;
        while (XMLDeclarationParser.isWhitespace(c)) {
            c = rd.read();
            if (c >= 0) continue;
            throw new XMLDeclarationException();
        }
        return c;
    }

    private static String readString(Reader rd, int bc) throws XMLDeclarationException, IOException {
        StringBuilder b = new StringBuilder();
        int c = bc;
        XMLDeclarationParser.skipWhitespace(rd, c);
        if (c != 61) {
            throw new XMLDeclarationException();
        }
        c = rd.read();
        if (c < 0) {
            throw new XMLDeclarationException();
        }
        XMLDeclarationParser.skipWhitespace(rd, c);
        int d = c;
        if (c != 39 && c != 34) {
            throw new XMLDeclarationException();
        }
        do {
            if ((c = rd.read()) < 0) {
                throw new XMLDeclarationException();
            }
            b.append((char)c);
        } while (c != 39 && c != 34);
        b.deleteCharAt(b.length() - 1);
        if (c != d) {
            throw new XMLDeclarationException();
        }
        return b.toString();
    }

    public static XMLDeclaration parseDeclaration(Reader rd) throws IOException, XMLDeclarationException {
        int c;
        XMLDeclaration d = XMLDeclaration.newDefault();
        int state = 0;
        while ((c = rd.read()) > 0) {
            switch (state) {
                case 0: {
                    if (c == 60) {
                        state = 1;
                        break;
                    }
                    return null;
                }
                case 1: {
                    if (c == 63) {
                        state = 2;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (c == 120 || c == 88) {
                        state = 3;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (c == 109 || c == 77) {
                        state = 4;
                        break;
                    }
                    return null;
                }
                case 4: {
                    if (c == 108 || c == 76) {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if (!XMLDeclarationParser.isWhitespace(c)) {
                        return null;
                    }
                    state = 101;
                    break;
                }
                case 101: {
                    c = XMLDeclarationParser.skipWhitespace(rd, c);
                    if (c == 118) {
                        state = 102;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 102: {
                    if (c == 101) {
                        state = 103;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 103: {
                    if (c == 114) {
                        state = 104;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 104: {
                    if (c == 115) {
                        state = 105;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 105: {
                    if (c == 105) {
                        state = 106;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 106: {
                    if (c == 111) {
                        state = 107;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 107: {
                    if (c == 110) {
                        state = 108;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 108: {
                    d.version = XMLDeclarationParser.readString(rd, c);
                    state = 200;
                    break;
                }
                case 200: {
                    c = XMLDeclarationParser.skipWhitespace(rd, c);
                    if (c == 101) {
                        state = 401;
                        break;
                    }
                    if (c == 115) {
                        state = 502;
                        break;
                    }
                    if (c == 63) {
                        state = 902;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 401: {
                    if (c == 110) {
                        state = 402;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 402: {
                    if (c == 99) {
                        state = 403;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 403: {
                    if (c == 111) {
                        state = 404;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 404: {
                    if (c == 100) {
                        state = 405;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 405: {
                    if (c == 105) {
                        state = 406;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 406: {
                    if (c == 110) {
                        state = 407;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 407: {
                    if (c == 103) {
                        state = 408;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 408: {
                    d.encoding = XMLDeclarationParser.readString(rd, c);
                    state = 501;
                    break;
                }
                case 501: {
                    c = XMLDeclarationParser.skipWhitespace(rd, c);
                    if (c == 115) {
                        state = 502;
                        break;
                    }
                    if (c == 63) {
                        state = 902;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 502: {
                    if (c == 116) {
                        state = 503;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 503: {
                    if (c == 97) {
                        state = 504;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 504: {
                    if (c == 110) {
                        state = 505;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 505: {
                    if (c == 100) {
                        state = 506;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 506: {
                    if (c == 97) {
                        state = 507;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 507: {
                    if (c == 108) {
                        state = 508;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 508: {
                    if (c == 111) {
                        state = 509;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 509: {
                    if (c == 110) {
                        state = 510;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 510: {
                    if (c == 101) {
                        state = 511;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 511: {
                    d.standalone = XMLDeclarationParser.readString(rd, c).equals("yes");
                    state = 901;
                    break;
                }
                case 901: {
                    c = XMLDeclarationParser.skipWhitespace(rd, c);
                    if (c == 63) {
                        state = 902;
                        break;
                    }
                    throw new XMLDeclarationException();
                }
                case 902: {
                    if (c == 62) {
                        return d;
                    }
                    throw new XMLDeclarationException();
                }
            }
        }
        throw new XMLDeclarationException();
    }
}

