/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.morilib.util.Iterators;
import net.morilib.util.table.AbstractTable;
import net.morilib.util.table.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListTable<E>
extends AbstractTable<E>
implements Serializable {
    private static final long serialVersionUID = -3584020203907523829L;
    private List<List<E>> table;
    private int rowsize;
    private int colsize;

    public ArrayListTable(E[] ... table) {
        if (table == null) {
            throw new NullPointerException();
        }
        if (table.length == 0) {
            this.table = Collections.emptyList();
        }
        int len = table[0].length;
        this.table = new ArrayList<List<E>>();
        int i = 0;
        while (i < table.length) {
            E[] e = table[i];
            if (e.length != len) {
                throw new IllegalArgumentException("length must be equal" + e.length);
            }
            this.table.add(new ArrayList<E>(Arrays.asList(e)));
            ++i;
        }
    }

    public ArrayListTable(Table<E> table) {
        if (table == null) {
            throw new NullPointerException();
        }
        this.table = new ArrayList<List<E>>();
        int i = 0;
        while (i < table.rowSize()) {
            this.table.add(table.getRow(i));
            ++i;
        }
    }

    @Override
    protected void addColumn(int col) {
        if (col < 0) {
            throw new IndexOutOfBoundsException("" + col);
        }
        if (col <= this.colsize) {
            for (List<Object> list : this.table) {
                list.add(col, null);
            }
            ++this.colsize;
        } else {
            throw new IndexOutOfBoundsException("" + col);
        }
    }

    @Override
    protected void addRow(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException("" + row);
        }
        if (row <= this.colsize) {
            this.table.add(row, new ArrayList());
            ++this.rowsize;
        } else {
            throw new IndexOutOfBoundsException("" + row);
        }
    }

    @Override
    public int columnSize() {
        return this.colsize;
    }

    @Override
    public E get(int r, int c) {
        if (r < 0 || r >= this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + r);
        }
        if (c < 0 || c >= this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + c);
        }
        return this.table.get(r).get(c);
    }

    @Override
    public int rowSize() {
        return this.rowsize;
    }

    @Override
    public List<E> getRow(int row) {
        return Collections.unmodifiableList(this.table.get(row));
    }

    @Override
    public void clear() {
        for (List<E> l : this.table) {
            l.clear();
        }
        this.table.clear();
        this.colsize = 0;
        this.rowsize = 0;
    }

    @Override
    public E set(int r, int c, E o) {
        if (r < 0 || r >= this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + r);
        }
        if (c < 0 || c >= this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + c);
        }
        return this.table.get(r).set(c, o);
    }

    @Override
    public Iterator<E> rowIterator(int row) {
        return Iterators.unmodifiable(this.table.get(row).iterator());
    }
}

