/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.morilib.util.iterator.IndexIterator;
import net.morilib.util.iterator.NullSkipIterator;
import net.morilib.util.table.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTable<E>
implements Table<E> {
    protected AbstractTable() {
    }

    @Override
    public abstract E get(int var1, int var2);

    @Override
    public abstract int rowSize();

    @Override
    public abstract int columnSize();

    @Override
    public List<E> getColumn(int col) {
        ArrayList<E> res = new ArrayList<E>();
        int i = 0;
        while (i < this.rowSize()) {
            res.add(this.get(i, col));
            ++i;
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public List<E> getRow(int row) {
        ArrayList<E> res = new ArrayList<E>();
        int i = 0;
        while (i < this.columnSize()) {
            res.add(this.get(row, i));
            ++i;
        }
        return Collections.unmodifiableList(res);
    }

    @Override
    public Iterator<E> rowIterator(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + row);
        }
        return new _RowIter(this, row, 0, this.columnSize());
    }

    @Override
    public Iterator<E> columnIterator(int column) {
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + column);
        }
        return new _ColumnIter(this, column, 0, this.rowSize());
    }

    @Override
    public Iterator<E> wholeIterator() {
        return new _Iter(this, 0, this.rowSize(), 0, this.columnSize());
    }

    @Override
    public E set(int x, int y, E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setRow(int row, List<E> list) {
        return this.setRow(row, list, 0, this.columnSize());
    }

    @Override
    public int setRow(int row, List<E> list, int cbgn, int cend) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + row);
        }
        if (cbgn < 0 || cbgn > this.columnSize()) {
            throw new IndexOutOfBoundsException("begin " + cbgn);
        }
        if (cend < 0 || cend > this.columnSize()) {
            throw new IndexOutOfBoundsException("end " + cend);
        }
        if (cbgn > cend) {
            throw new IllegalArgumentException(String.valueOf(cbgn) + ">" + cend);
        }
        int i = cbgn;
        while (i < cend && i - cbgn < list.size()) {
            this.set(row, i, list.get(i - cbgn));
            ++i;
        }
        return i - cbgn;
    }

    @Override
    public int setColumn(int col, List<E> list) {
        return this.setColumn(col, list, 0, this.rowSize());
    }

    @Override
    public int setColumn(int col, List<E> list, int rbgn, int rend) {
        if (col < 0 || col >= this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + col);
        }
        if (rbgn < 0 || rbgn > this.rowSize()) {
            throw new IndexOutOfBoundsException("begin " + rbgn);
        }
        if (rend < 0 || rend > this.rowSize()) {
            throw new IndexOutOfBoundsException("end " + rend);
        }
        if (rbgn > rend) {
            throw new IllegalArgumentException(String.valueOf(rbgn) + ">" + rend);
        }
        int i = rbgn;
        while (i < rend && i - rbgn < list.size()) {
            this.set(i, col, list.get(i - rbgn));
            ++i;
        }
        return i - rbgn;
    }

    protected abstract void addRow(int var1);

    @Override
    public int addRow(int row, List<E> list) {
        this.addRow(row);
        return this.setRow(row, list);
    }

    @Override
    public int addRow(List<E> list) {
        return this.addRow(this.rowSize(), list);
    }

    @Override
    public void deleteRow(int row) {
        throw new UnsupportedOperationException();
    }

    protected abstract void addColumn(int var1);

    @Override
    public int addColumn(int col, List<E> list) {
        this.addColumn(col);
        return this.setColumn(col, list);
    }

    @Override
    public int addColumn(List<E> list) {
        return this.addColumn(this.columnSize(), list);
    }

    @Override
    public void deleteColumn(int col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Table<E> subTable(int r1, int r2, int c1, int c2) {
        if (r1 < 0 || r1 > this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + r1);
        }
        if (c1 < 0 || c1 > this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + c1);
        }
        if (r2 < 0 || r2 > this.rowSize()) {
            throw new IndexOutOfBoundsException("row " + r2);
        }
        if (c2 < 0 || c2 > this.columnSize()) {
            throw new IndexOutOfBoundsException("column " + c2);
        }
        if (r1 > r2 || c1 > c2) {
            throw new IllegalArgumentException();
        }
        return new SubTable(this, r1, r2, c1, c2);
    }

    @Override
    public Iterator<E> columnIteratorNotNull(int column) {
        return new NullSkipIterator<E>(this.columnIterator(column));
    }

    @Override
    public Iterator<E> rowIteratorNotNull(int row) {
        return new NullSkipIterator<E>(this.rowIterator(row));
    }

    @Override
    public Iterator<E> wholeIteratorNotNull() {
        return new NullSkipIterator<E>(this.wholeIterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubTable<E, T extends Table<E>>
    implements Table<E> {
        int r1;
        int r2;
        int c1;
        int c2;
        T table;

        SubTable(T table, int r1, int r2, int c1, int c2) {
            this.table = table;
            this.r1 = r1;
            this.r2 = r2;
            this.c1 = c1;
            this.c2 = c2;
        }

        void checkRange(int x, int y) {
            if (x < 0 || x >= this.r2 - this.r1) {
                throw new IndexOutOfBoundsException("row " + x);
            }
            if (y < 0 || y >= this.c2 - this.c1) {
                throw new IndexOutOfBoundsException("column " + y);
            }
        }

        void checkRange(int x1, int x2, int y1, int y2) {
            if (x1 < 0 || x1 > this.r2 - this.r1) {
                throw new IndexOutOfBoundsException("row " + x1);
            }
            if (y1 < 0 || y1 > this.c2 - this.c1) {
                throw new IndexOutOfBoundsException("column " + y1);
            }
            if (x2 < 0 || x2 > this.r2 - this.r1) {
                throw new IndexOutOfBoundsException("row " + x2);
            }
            if (y2 < 0 || y2 > this.c2 - this.c1) {
                throw new IndexOutOfBoundsException("column " + y2);
            }
            if (x1 > x2 || y1 > y2) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public E get(int x, int y) {
            this.checkRange(x, y);
            return this.table.get(x + this.r1, y + this.c1);
        }

        @Override
        public E set(int x, int y, E o) {
            this.checkRange(x, y);
            return this.table.set(x + this.r1, y + this.c1, o);
        }

        @Override
        public int rowSize() {
            return this.r2 - this.r1;
        }

        @Override
        public int columnSize() {
            return this.c2 - this.c1;
        }

        @Override
        public Iterator<E> wholeIterator() {
            return new _Iter(this, this.r1, this.r2, this.c1, this.c2);
        }

        @Override
        public Iterator<E> rowIterator(int row) {
            if (row < 0 || row >= this.rowSize()) {
                throw new IndexOutOfBoundsException("row " + row);
            }
            return new _RowIter(this, row + this.r1, this.c1, this.c2);
        }

        @Override
        public Iterator<E> columnIterator(int column) {
            if (column < 0 || column >= this.columnSize()) {
                throw new IndexOutOfBoundsException("column " + column);
            }
            return new _ColumnIter(this, column + this.c1, this.r1, this.r2);
        }

        @Override
        public Table<E> subTable(int x1, int x2, int y1, int y2) {
            this.checkRange(x1, x2, y1, y2);
            return new SubTable<E, SubTable>(this, x1 + this.r1, x2 + this.r1, y1 + this.c1, y2 + this.c1);
        }

        @Override
        public int setRow(int row, List<E> list) {
            return this.setRow(row, list, 0, this.columnSize());
        }

        @Override
        public int addRow(int row, List<E> list) {
            if (row < 0 || row > this.rowSize()) {
                throw new IndexOutOfBoundsException("" + row);
            }
            ++this.r2;
            return this.table.addRow(row + this.r1, list);
        }

        @Override
        public int addRow(List<E> list) {
            return this.table.addRow(this.r2++, list);
        }

        @Override
        public void deleteRow(int row) {
            if (row < 0 || row >= this.rowSize()) {
                throw new IndexOutOfBoundsException("" + row);
            }
            --this.r2;
            this.table.deleteRow(row + this.r1);
        }

        @Override
        public int setColumn(int col, List<E> list) {
            return this.setColumn(col, list, 0, this.rowSize());
        }

        @Override
        public int addColumn(int col, List<E> list) {
            if (col < 0 || col > this.columnSize()) {
                throw new IndexOutOfBoundsException("" + col);
            }
            ++this.c2;
            return this.table.addColumn(col + this.c1, list);
        }

        @Override
        public int addColumn(List<E> list) {
            return this.table.addColumn(this.c2++, list);
        }

        @Override
        public void deleteColumn(int col) {
            if (col < 0 || col >= this.columnSize()) {
                throw new IndexOutOfBoundsException("" + col);
            }
            --this.c2;
            this.table.deleteRow(col + this.c1);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setRow(int row, List<E> list, int cbgn, int cend) {
            if (row < 0 || row >= this.rowSize()) {
                throw new IndexOutOfBoundsException("row " + row);
            }
            if (cbgn < 0 || cbgn > this.columnSize()) {
                throw new IndexOutOfBoundsException("begin " + cbgn);
            }
            if (cend < 0 || cend > this.columnSize()) {
                throw new IndexOutOfBoundsException("end " + cend);
            }
            if (cbgn > cend) {
                throw new IllegalArgumentException(String.valueOf(cbgn) + ">" + cend);
            }
            return this.table.setRow(row, list, cbgn + this.c1, cend + this.c1);
        }

        @Override
        public int setColumn(int col, List<E> list, int rbgn, int rend) {
            if (col < 0 || col >= this.columnSize()) {
                throw new IndexOutOfBoundsException("column " + col);
            }
            if (rbgn < 0 || rbgn > this.rowSize()) {
                throw new IndexOutOfBoundsException("begin " + rbgn);
            }
            if (rend < 0 || rend > this.rowSize()) {
                throw new IndexOutOfBoundsException("end " + rend);
            }
            if (rbgn > rend) {
                throw new IllegalArgumentException(String.valueOf(rbgn) + ">" + rend);
            }
            return this.table.setColumn(col, list, rbgn + this.r1, rend + this.r1);
        }

        @Override
        public List<E> getColumn(int col) {
            return this.table.getColumn(col).subList(this.c1, this.c2);
        }

        @Override
        public List<E> getRow(int row) {
            return this.table.getRow(row).subList(this.r1, this.r2);
        }

        @Override
        public Iterator<E> columnIteratorNotNull(int column) {
            return new NullSkipIterator<E>(this.columnIterator(column));
        }

        @Override
        public Iterator<E> rowIteratorNotNull(int row) {
            return new NullSkipIterator<E>(this.rowIterator(row));
        }

        @Override
        public Iterator<E> wholeIteratorNotNull() {
            return new NullSkipIterator<E>(this.wholeIterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _ColumnIter<E>
    extends IndexIterator<E> {
        private Table<E> table;
        private int col;

        public _ColumnIter(Table<E> tbl, int col, int begin, int end) {
            super(begin, end);
            this.table = tbl;
            this.col = col;
        }

        @Override
        protected E get(int index) {
            return this.table.get(index, this.col);
        }

        @Override
        protected void set(int index, E o) {
            this.table.set(index, this.col, o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _Iter<E>
    implements Iterator<E> {
        private Table<E> table;
        private int _ptrr;
        private int _ptrc;
        private int r2;
        private int c1;
        private int c2;

        private _Iter(Table<E> tbl, int r1, int r2, int c1, int c2) {
            this.table = tbl;
            this._ptrr = r1;
            this.r2 = r2;
            this.c1 = this._ptrc = c1;
            this.c2 = c2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this._ptrr < this.r2;
        }

        @Override
        public E next() {
            E res = this.table.get(this._ptrr, this._ptrc++);
            if (this._ptrc >= this.c2) {
                ++this._ptrr;
                this._ptrc = this.c1;
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _RowIter<E>
    extends IndexIterator<E> {
        private Table<E> table;
        private int row;

        public _RowIter(Table<E> tbl, int row, int begin, int end) {
            super(begin, end);
            this.table = tbl;
            this.row = row;
        }

        @Override
        protected E get(int index) {
            return this.table.get(this.row, index);
        }

        @Override
        protected void set(int index, E o) {
            this.table.set(this.row, index, o);
        }
    }
}

