/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.string;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.ArrayListStack;
import net.morilib.util.Stack2;
import net.morilib.util.map.KeyTyped;
import net.morilib.util.primitive.CharacterArrayVector;
import net.morilib.util.primitive.CharacterVector;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.CharacterIterators;
import net.morilib.util.primitive.map.po.CharacterHashMap;
import net.morilib.util.primitive.map.po.CharacterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@KeyTyped(value=String.class)
public class StringTrieMap<V>
extends AbstractMap<String, V> {
    private Set<Map.Entry<String, V>> entrySet = null;
    private Entry<V> root = null;
    private int size;

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ESet();
        }
        return this.entrySet();
    }

    @Override
    public int size() {
        return this.size;
    }

    private Entry<V> traverse(CharacterIterator s) {
        Entry<V> now = this.root;
        while (s.hasNext()) {
            char c = s.next();
            if (now.entries == null) {
                return null;
            }
            if (!now.entries.containsKeyElement(c)) {
                return null;
            }
            now = now.entries.getElement(c);
        }
        return now;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            Entry<V> e = this.traverse(CharacterIterators.newIterator((String)key));
            return e != null;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            Entry<V> e = this.traverse(CharacterIterators.newIterator((String)key));
            return e.value;
        }
        return null;
    }

    @Override
    public V put(String key, V value) {
        Entry<V> now = this.root;
        CharacterIterator s = CharacterIterators.newIterator(key);
        while (s.hasNext()) {
            char c = s.next();
            if (now.entries == null) {
                now.entries = new CharacterHashMap();
                now.entries.putElement(c, new Entry());
            } else if (!now.entries.containsKeyElement(c)) {
                now.entries.putElement(c, new Entry());
            }
            now = now.entries.getElement(c);
        }
        Object r = now.value;
        now.exist = true;
        now.value = value;
        return r;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ESet
    extends AbstractSet<Map.Entry<String, V>> {
        private ESet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new Iter(StringTrieMap.this.root);
        }

        @Override
        public int size() {
            return StringTrieMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V> {
        boolean exist;
        V value;
        CharacterMap<Entry<V>> entries = null;

        Entry() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Iter<V>
    implements Iterator<Map.Entry<String, V>> {
        private Entry<V> now;
        private Stack2<Iterator<CharacterMap.PrimitiveEntryK<Entry<V>>>> iteratorStack = new ArrayListStack<Iterator<CharacterMap.PrimitiveEntryK<Entry<V>>>>();
        private CharacterVector res = new CharacterArrayVector();

        private boolean _ready() {
            while (!this.iteratorStack.isEmpty() && !this.iteratorStack.peek().hasNext()) {
                this.iteratorStack.pop();
                this.res.remove(this.res.size() - 1);
            }
            return this.iteratorStack.isEmpty();
        }

        private Entry<V> _next() {
            CharacterMap.PrimitiveEntryK<Entry<V>> e;
            do {
                if (this.now.entries != null) {
                    this.iteratorStack.push(this.now.entries.charKeyEntrySet().iterator());
                } else if (this.iteratorStack.peek().hasNext()) {
                    this.res.remove(this.res.size() - 1);
                } else if (this._ready()) {
                    return null;
                }
                e = this.iteratorStack.peek().next();
                this.res.addChar(e.getKey());
            } while (!e.getValue().exist);
            return e.getValue();
        }

        Iter(Entry<V> now) {
            this.now = now;
            if (now != null) {
                this.iteratorStack.push(now.entries.charKeyEntrySet().iterator());
            }
        }

        @Override
        public boolean hasNext() {
            return this.iteratorStack.isEmpty();
        }

        @Override
        public Map.Entry<String, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            final Entry<V> e = this.now;
            final String s = new String(this.res.toCharArray());
            this.now = this._next();
            return new Map.Entry<String, V>(){

                @Override
                public String getKey() {
                    return s;
                }

                @Override
                public V getValue() {
                    return e.value;
                }

                @Override
                public V setValue(V value) {
                    Object r = e.value;
                    e.value = value;
                    return r;
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

