/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.string;

import net.morilib.util.IntMath;
import net.morilib.util.Pointer;
import net.morilib.util.PointerMismatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringPointer
implements Pointer<String, Character> {
    private String string;
    private int ptr;

    public StringPointer(String str, int ptr) {
        if (str == null) {
            throw new NullPointerException();
        }
        this.string = str;
        this.ptr = ptr;
    }

    public StringPointer(String str) {
        this(str, 0);
    }

    public StringPointer inclement() {
        ++this.ptr;
        return this;
    }

    public StringPointer declement() {
        --this.ptr;
        return this;
    }

    public StringPointer add(int x) {
        this.ptr += x;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.ptr >= 0 && this.ptr < this.string.length();
    }

    @Override
    public boolean isValid(int x) {
        return this.ptr + x >= 0 && this.ptr + x < this.string.length();
    }

    @Override
    public Character refer() {
        if (!this.isValid()) {
            throw new StringIndexOutOfBoundsException();
        }
        return Character.valueOf(this.string.charAt(this.ptr));
    }

    @Override
    public Character referSafe() {
        return this.isValid() ? Character.valueOf(this.string.charAt(this.ptr)) : null;
    }

    @Override
    public Character indexOf(int x) {
        if (!this.isValid(x)) {
            throw new StringIndexOutOfBoundsException();
        }
        return Character.valueOf(this.string.charAt(this.ptr + x));
    }

    @Override
    public Character indexOfSafe(int x) {
        return this.isValid() ? Character.valueOf(this.string.charAt(this.ptr + x)) : null;
    }

    @Override
    public int subtract(Pointer<String, Character> p) {
        if (!(p instanceof StringPointer)) {
            throw new PointerMismatchException();
        }
        if (this.string != ((StringPointer)p).string) {
            throw new PointerMismatchException();
        }
        return this.ptr - ((StringPointer)p).ptr;
    }

    public int charAt() {
        if (!this.isValid()) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.string.charAt(this.ptr);
    }

    public int charAtSafe() {
        return this.isValid() ? (int)this.string.charAt(this.ptr) : -1;
    }

    public int charAt(int x) {
        if (!this.isValid(x)) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.string.charAt(this.ptr + x);
    }

    public int charAtSafe(int x) {
        return this.isValid(x) ? (int)this.string.charAt(this.ptr + x) : -1;
    }

    @Override
    public int getIndex() {
        return this.ptr;
    }

    public StringPointer clone() {
        return new StringPointer(this.string, this.ptr);
    }

    public StringPointer overwrite(Pointer<String, Character> p) {
        if (!(p instanceof StringPointer)) {
            throw new PointerMismatchException();
        }
        if (this.string != ((StringPointer)p).string) {
            throw new PointerMismatchException();
        }
        this.ptr = ((StringPointer)p).ptr;
        return this;
    }

    @Override
    public String getReferent() {
        return this.string;
    }

    public StringPointer moveStart() {
        this.ptr = 0;
        return this;
    }

    public StringPointer moveEnd() {
        this.ptr = this.string.length() - 1;
        return this;
    }

    public int hashCode() {
        int r = 17;
        r = r * 37 + this.string.hashCode();
        r = r * 37 + this.ptr;
        return r;
    }

    public boolean equals(Object p) {
        if (!(p instanceof StringPointer)) {
            return false;
        }
        if (this.string != ((StringPointer)p).string) {
            return false;
        }
        return this.ptr == ((StringPointer)p).ptr;
    }

    @Override
    public int compareTo(Pointer<String, Character> p) {
        if (!(p instanceof StringPointer)) {
            throw new PointerMismatchException();
        }
        if (this.string != ((StringPointer)p).string) {
            throw new PointerMismatchException();
        }
        return IntMath.compareTo(this.ptr, ((StringPointer)p).ptr);
    }
}

