/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSet<T>
implements Set<T> {
    private IdentityHashMap<T, Object> map = new IdentityHashMap();

    public IdentityHashSet() {
    }

    public IdentityHashSet(Collection<? extends T> c) {
        this();
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<Map.Entry<T, Object>> i = this.map.entrySet().iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                return ((Map.Entry)i.next()).getKey();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public T[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean add(T e) {
        return this.map.put(e, e) != null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean r = false;
        for (T x : c) {
            r = this.map.put(x, x) != null | r;
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean r = false;
        for (T x : this) {
            if (c.contains(x)) continue;
            r = this.map.remove(x) != null | r;
        }
        return r;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = false;
        for (Object x : c) {
            r = this.map.remove(x) != null | r;
        }
        return r;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

