/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.map.pp.AbstractLongCharacterMap;
import net.morilib.util.primitive.map.pp.LongCharacterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongCharacterHashMap
extends AbstractLongCharacterMap
implements Serializable {
    private static final long serialVersionUID = -2524637876889987554L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object MARK_A = new Object();
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;
    private transient Set<LongCharacterMap.PrimitiveEntry> entrySet;

    /*
     * Unable to fully structure code
     */
    public LongCharacterHashMap(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            this.entrySet = null;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl13
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl13:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public LongCharacterHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongCharacterHashMap(float loadFactor) {
        this(16, loadFactor);
    }

    public LongCharacterHashMap() {
        this(16, 0.75f);
    }

    public LongCharacterHashMap(LongCharacterMap mp) {
        this(16, 0.75f);
        this.putAllElement(mp);
    }

    private Iterator<LongCharacterMap.PrimitiveEntry> entrySetIterator() {
        return new Iterator<LongCharacterMap.PrimitiveEntry>(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = LongCharacterHashMap.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (LongCharacterHashMap.access$2(LongCharacterHashMap.this)[this.ptr] == null) continue;
                    return LongCharacterHashMap.access$2(LongCharacterHashMap.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < LongCharacterHashMap.access$2((LongCharacterHashMap)LongCharacterHashMap.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public LongCharacterMap.PrimitiveEntry next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != LongCharacterHashMap.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                LongCharacterHashMap.this._remove(this.remove.key);
                this.exModCount = LongCharacterHashMap.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public Set<LongCharacterMap.PrimitiveEntry> primitiveEntrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<LongCharacterMap.PrimitiveEntry>(){

                @Override
                public Iterator<LongCharacterMap.PrimitiveEntry> iterator() {
                    return LongCharacterHashMap.this.entrySetIterator();
                }

                @Override
                public int size() {
                    return LongCharacterHashMap.this.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(long k) {
        return (int)k;
    }

    private Ent _get(long k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsKeyElement(long k) {
        return this._get(k) != null;
    }

    @Override
    public char f(long k) {
        return this._get(k).value;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
                long b = e.getKey();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b, e.getValue());
                    continue;
                }
                ne[h].putEntry(b, Character.valueOf(e.getValue()));
            }
        }
    }

    @Override
    public Character putElement(long k, char v) {
        int h = this.getHash(k) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(k, v);
            return null;
        }
        Object r = this.ent[h].putEntry(k, Character.valueOf(v));
        if (r == MARK_A) {
            ++this.size;
            this.resize();
            return null;
        }
        return (Character)r;
    }

    private boolean _putEntry(long k, Character v) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(k, v.charValue());
            return true;
        }
        return this.ent[h].putEntry(k, v) != MARK_A;
    }

    private Ent _remove(long k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].key) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public Character removeElement(long k) {
        Ent r = this._remove(k);
        return r != null ? Character.valueOf(r.value) : null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        for (LongCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            s.writeLong(e.getKey());
            s.writeObject(Character.valueOf(e.getValue()));
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            long k = s.readLong();
            Character v = (Character)s.readObject();
            this._putEntry(k, v);
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$2(LongCharacterHashMap longCharacterHashMap) {
        return longCharacterHashMap.ent;
    }

    private static class Ent
    implements LongCharacterMap.PrimitiveEntry {
        private long key;
        private char value;
        private Ent next;

        private Ent(long key, char value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return (int)this.key;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.key == e.key;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(Long.toString(this.key)) + "=" + this.value;
        }

        private Ent searchEntry(long k) {
            Ent f = this;
            while (f != null) {
                if (k == f.key) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(long k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private Object putEntry(long k, Character v) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.key) {
                    Character r = Character.valueOf(f.value);
                    f.value = v.charValue();
                    return r;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent(k, v.charValue());
            return MARK_A;
        }

        public long getKey() {
            return this.key;
        }

        public char getValue() {
            return this.value;
        }

        public char setValue(char v) {
            char r = this.value;
            this.value = v;
            return r;
        }
    }
}

